/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.javascript.metrics.MetricsVisitor;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public class CounterVisitor
extends SubscriptionVisitor {
    private int functionCounter = 0;
    private int statementCounter = 0;
    private int classCounter = 0;
    private static final Tree.Kind[] STATEMENT_NODES = new Tree.Kind[]{Tree.Kind.VARIABLE_STATEMENT, Tree.Kind.EMPTY_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.WITH_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT};

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> result = new ArrayList<Tree.Kind>(KindSet.FUNCTION_KINDS.getSubKinds());
        result.addAll(Arrays.asList(STATEMENT_NODES));
        result.addAll(Arrays.asList(MetricsVisitor.getClassNodes()));
        return result;
    }

    public CounterVisitor(Tree tree) {
        this.scanTree(tree);
    }

    public int getFunctionNumber() {
        return this.functionCounter;
    }

    public int getStatementsNumber() {
        return this.statementCounter;
    }

    public int getClassNumber() {
        return this.classCounter;
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(KindSet.FUNCTION_KINDS)) {
            ++this.functionCounter;
        } else if (tree.is(STATEMENT_NODES)) {
            ++this.statementCounter;
        } else if (tree.is(MetricsVisitor.getClassNodes())) {
            ++this.classCounter;
        }
    }
}

