/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.builtins.BuiltInObjectSymbolicValue;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;

public enum Type {
    OBJECT(Constraint.OBJECT, BuiltInObjectSymbolicValue.OBJECT_PROTOTYPE),
    NUMBER_PRIMITIVE(Constraint.NUMBER_PRIMITIVE, BuiltInObjectSymbolicValue.NUMBER_PROTOTYPE),
    NUMBER_OBJECT(Constraint.NUMBER_OBJECT, BuiltInObjectSymbolicValue.NUMBER_PROTOTYPE),
    STRING_PRIMITIVE(Constraint.STRING_PRIMITIVE, BuiltInObjectSymbolicValue.STRING_PROTOTYPE),
    STRING_OBJECT(Constraint.STRING_OBJECT, BuiltInObjectSymbolicValue.STRING_PROTOTYPE),
    BOOLEAN_PRIMITIVE(Constraint.BOOLEAN_PRIMITIVE, BuiltInObjectSymbolicValue.BOOLEAN_PROTOTYPE),
    BOOLEAN_OBJECT(Constraint.BOOLEAN_OBJECT, BuiltInObjectSymbolicValue.BOOLEAN_PROTOTYPE),
    FUNCTION(Constraint.FUNCTION, BuiltInObjectSymbolicValue.FUNCTION_PROTOTYPE),
    ARRAY(Constraint.ARRAY, BuiltInObjectSymbolicValue.ARRAY_PROTOTYPE),
    DATE(Constraint.DATE, BuiltInObjectSymbolicValue.DATE_PROTOTYPE),
    REGEXP(Constraint.REGEXP, BuiltInObjectSymbolicValue.REGEXP_PROTOTYPE),
    NULL(Constraint.NULL, null),
    UNDEFINED(Constraint.UNDEFINED, null);

    private static final List<Type> VALUES_REVERSED;
    private static final EnumSet<Type> PRIMITIVE_TYPES;
    private final Constraint constraint;
    private final BuiltInObjectSymbolicValue prototype;

    private Type(Constraint constraint, BuiltInObjectSymbolicValue prototype) {
        this.constraint = constraint;
        this.prototype = prototype;
    }

    public Constraint constraint() {
        return this.constraint;
    }

    public SymbolicValue getPropertyValue(String propertyName) {
        if (this.prototype == null) {
            throw new IllegalStateException("Cannot access a property on a " + (Object)((Object)this));
        }
        SymbolicValue propertyValue = this.prototype.getPropertyValue(propertyName);
        if (!SpecialSymbolicValue.UNDEFINED.equals(propertyValue) || PRIMITIVE_TYPES.contains((Object)this)) {
            return propertyValue;
        }
        return UnknownSymbolicValue.UNKNOWN;
    }

    @CheckForNull
    public BuiltInObjectSymbolicValue prototype() {
        return this.prototype;
    }

    public static Type find(Constraint constraint) {
        for (Type type : VALUES_REVERSED) {
            if (!constraint.isStricterOrEqualTo(type.constraint())) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES_REVERSED = Lists.reverse(Arrays.asList(Type.values()));
        PRIMITIVE_TYPES = EnumSet.of(NUMBER_PRIMITIVE, new Type[]{NUMBER_OBJECT, STRING_PRIMITIVE, STRING_OBJECT, BOOLEAN_PRIMITIVE, BOOLEAN_OBJECT});
    }
}

