/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

public abstract class JavaScriptTree
implements Tree {
    private JavaScriptTree parent;

    public int getLine() {
        return this.getFirstToken().line();
    }

    @Override
    public final boolean is(Kinds ... kind) {
        if (this.getKind() != null) {
            for (Kinds kindIter : kind) {
                if (!kindIter.contains(this.getKind())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Tree.Kind getKind();

    public abstract Iterator<Tree> childrenIterator();

    public boolean isLeaf() {
        return false;
    }

    public SyntaxToken getLastToken() {
        SyntaxToken lastToken = null;
        Iterator<Tree> childrenIterator = this.childrenIterator();
        while (childrenIterator.hasNext()) {
            SyntaxToken childLastToken;
            JavaScriptTree child = (JavaScriptTree)childrenIterator.next();
            if (child == null || (childLastToken = child.getLastToken()) == null) continue;
            lastToken = childLastToken;
        }
        return lastToken;
    }

    public SyntaxToken getFirstToken() {
        Tree child;
        Iterator<Tree> childrenIterator = this.childrenIterator();
        do {
            if (!childrenIterator.hasNext()) {
                throw new IllegalStateException("Tree has no non-null children " + this.getKind());
            }
            child = childrenIterator.next();
        } while (child == null);
        return ((JavaScriptTree)child).getFirstToken();
    }

    public boolean isAncestorOf(JavaScriptTree tree) {
        JavaScriptTree parentTree = tree.getParent();
        if (this.equals(parentTree)) {
            return true;
        }
        if (parentTree == null) {
            return false;
        }
        return this.isAncestorOf(parentTree);
    }

    public Stream<JavaScriptTree> descendants() {
        if (this.isLeaf()) {
            return Stream.empty();
        }
        Stream<JavaScriptTree> kins = this.childrenStream().filter(Objects::nonNull).filter(tree -> tree instanceof JavaScriptTree).map(tree -> (JavaScriptTree)tree);
        Iterator<Tree> iterator = this.childrenIterator();
        while (iterator.hasNext()) {
            Tree tree2 = iterator.next();
            if (tree2 == null) continue;
            kins = Stream.concat(kins, ((JavaScriptTree)tree2).descendants());
        }
        return kins;
    }

    private Stream<Tree> childrenStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.childrenIterator(), 16), false);
    }

    public void setParent(Tree parent) {
        this.parent = (JavaScriptTree)parent;
    }

    public JavaScriptTree getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Tree> children = this.childrenIterator();
        while (children.hasNext()) {
            sb.append(children.next());
            sb.append(" ");
        }
        return sb.toString();
    }
}

