/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.declaration.FunctionTreeImpl;
import org.sonar.javascript.tree.impl.statement.BlockTreeImpl;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class FunctionExpressionTreeImpl
extends FunctionTreeImpl
implements FunctionExpressionTree,
TypableTree {
    private final SyntaxToken asyncToken;
    private final SyntaxToken functionKeyword;
    private final SyntaxToken star;
    private final IdentifierTree name;
    private final ParameterListTree parameters;
    private final BlockTreeImpl body;
    private final Tree.Kind kind;
    private Type functionType;

    private FunctionExpressionTreeImpl(@Nullable SyntaxToken asyncToken, SyntaxToken functionKeyword, @Nullable SyntaxToken star, IdentifierTree name, ParameterListTree parameters, BlockTreeImpl body) {
        this.asyncToken = asyncToken;
        this.functionKeyword = functionKeyword;
        this.star = star;
        this.name = name;
        this.parameters = parameters;
        this.body = body;
        this.kind = star == null ? Tree.Kind.FUNCTION_EXPRESSION : Tree.Kind.GENERATOR_FUNCTION_EXPRESSION;
        this.functionType = FunctionType.create(this);
    }

    public static FunctionExpressionTree createGenerator(SyntaxToken functionKeyword, SyntaxToken star, @Nullable IdentifierTree name, ParameterListTree parameters, BlockTreeImpl body) {
        return new FunctionExpressionTreeImpl(null, functionKeyword, star, name, parameters, body);
    }

    public static FunctionExpressionTree create(@Nullable SyntaxToken asyncToken, SyntaxToken functionToken, @Nullable IdentifierTree name, ParameterListTree parameters, BlockTreeImpl body) {
        return new FunctionExpressionTreeImpl(asyncToken, functionToken, null, name, parameters, body);
    }

    @Override
    public SyntaxToken functionKeyword() {
        return this.functionKeyword;
    }

    @Override
    @Nullable
    public SyntaxToken star() {
        return this.star;
    }

    @Override
    @Nullable
    public IdentifierTree name() {
        return this.name;
    }

    @Override
    @Nullable
    public SyntaxToken asyncToken() {
        return this.asyncToken;
    }

    @Override
    public ParameterListTree parameterClause() {
        return this.parameters;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public BlockTreeImpl body() {
        return this.body;
    }

    @Override
    public List<Tree> parameterList() {
        return this.parameters.parameters();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.asyncToken, this.functionKeyword, this.star, this.name, this.parameters, this.body});
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitFunctionExpression(this);
    }

    @Override
    public TypeSet types() {
        TypeSet set = TypeSet.emptyTypeSet();
        set.add(this.functionType);
        return set;
    }

    @Override
    public void add(Type type) {
        throw new UnsupportedOperationException();
    }
}

