/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.javascript.tree.symbols.type.Utils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class WebAPI {
    private static final String DOCUMENT = "document";
    private static final List<String> DOCUMENT_METHODS_TO_GET_ELEMENT = ImmutableList.of((Object)"getElementById", (Object)"elementFromPoint", (Object)"createElement", (Object)"createElementNS");
    private static final List<String> DOCUMENT_METHODS_TO_GET_ELEMENTS = ImmutableList.of((Object)"getElementsByClassName", (Object)"getElementsByName", (Object)"getElementsByTagName", (Object)"getElementsByTagNameNS");
    private static final List<String> DOCUMENT_PROPERTIES_TO_GET_ELEMENT = ImmutableList.of((Object)"activeElement", (Object)"documentElement", (Object)"pointerLockElement");

    private WebAPI() {
    }

    public static boolean isWindow(ExpressionTree tree) {
        DotMemberExpressionTree memberAccess;
        DotMemberExpressionTree callee;
        if (tree instanceof CallExpressionTree && ((CallExpressionTree)tree).callee().is(Tree.Kind.DOT_MEMBER_EXPRESSION) && Utils.isPropertyAccess(callee = (DotMemberExpressionTree)((CallExpressionTree)tree).callee(), Type.Kind.WINDOW, "open")) {
            return true;
        }
        return tree.is(Tree.Kind.DOT_MEMBER_EXPRESSION) && (Utils.isPropertyAccess(memberAccess = (DotMemberExpressionTree)tree, Type.Kind.WINDOW, "frames") || Utils.isPropertyAccess(memberAccess, Type.Kind.DOM_ELEMENT, "contentWindow"));
    }

    public static boolean isDocument(IdentifierTree tree) {
        return tree.name().equals(DOCUMENT);
    }

    public static boolean isElement(ExpressionTree tree) {
        DotMemberExpressionTree callee;
        if (tree.is(Tree.Kind.CALL_EXPRESSION) && ((CallExpressionTree)tree).callee().is(Tree.Kind.DOT_MEMBER_EXPRESSION) && WebAPI.isDocumentUsed(callee = (DotMemberExpressionTree)((CallExpressionTree)tree).callee(), DOCUMENT_METHODS_TO_GET_ELEMENT)) {
            return true;
        }
        return tree.is(Tree.Kind.DOT_MEMBER_EXPRESSION) && WebAPI.isDocumentUsed((DotMemberExpressionTree)tree, DOCUMENT_PROPERTIES_TO_GET_ELEMENT);
    }

    private static boolean isDocumentUsed(DotMemberExpressionTree usage, List<String> propertiesToGetElement) {
        return usage.object().types().contains(Type.Kind.DOCUMENT) && propertiesToGetElement.contains(usage.property().name());
    }

    public static boolean isElementList(ExpressionTree tree) {
        DotMemberExpressionTree callee;
        return tree.is(Tree.Kind.CALL_EXPRESSION) && ((CallExpressionTree)tree).callee().is(Tree.Kind.DOT_MEMBER_EXPRESSION) && (callee = (DotMemberExpressionTree)((CallExpressionTree)tree).callee()).object().types().contains(Type.Kind.DOCUMENT) && DOCUMENT_METHODS_TO_GET_ELEMENTS.contains(callee.property().name());
    }
}

