/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.symbols;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.tree.impl.expression.IdentifierTreeImpl;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.symbols.Usage;

@Beta
public class Symbol {
    private final String name;
    private Kind kind;
    private boolean external;
    private Scope scope;
    private List<Usage> usages = new LinkedList<Usage>();
    private TypeSet types;

    public Symbol(String name, Kind kind, Scope scope) {
        this.name = name;
        this.kind = kind;
        this.external = false;
        this.scope = scope;
        this.types = TypeSet.emptyTypeSet();
    }

    public void addUsage(Usage usage) {
        this.usages.add(usage);
        ((IdentifierTreeImpl)usage.identifierTree()).setSymbol(this);
    }

    public Collection<Usage> usages() {
        return Collections.unmodifiableList(this.usages);
    }

    public Symbol setExternal(boolean external) {
        this.external = external;
        return this;
    }

    public Scope scope() {
        return this.scope;
    }

    public String name() {
        return this.name;
    }

    public boolean external() {
        return this.external;
    }

    public boolean is(Kind kind) {
        return kind.equals((Object)this.kind);
    }

    public Kind kind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public void addTypes(Set<Type> type) {
        this.types.addAll((Collection<? extends Type>)type);
    }

    public void addType(Type type) {
        this.types.add(type);
    }

    public TypeSet types() {
        return this.types.immutableCopy();
    }

    public boolean isVariable() {
        return this.kind == Kind.LET_VARIABLE || this.kind == Kind.CONST_VARIABLE || this.kind == Kind.VARIABLE;
    }

    public String toString() {
        return this.name();
    }

    public static enum Kind {
        VARIABLE("variable"),
        LET_VARIABLE("block scope variable"),
        CONST_VARIABLE("read-only variable"),
        FUNCTION("function"),
        METHOD("method"),
        PARAMETER("parameter"),
        IMPORT("imported symbol"),
        CLASS("class");

        private final String value;

        private Kind(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

