/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cpd;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.javascript.compat.CompatibleInputFile;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public class CpdVisitor
extends SubscriptionVisitor {
    private final SensorContext sensorContext;
    private CompatibleInputFile inputFile;
    private NewCpdTokens cpdTokens;

    public CpdVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    @Override
    public void visitFile(Tree scriptTree) {
        this.inputFile = (CompatibleInputFile)this.getContext().getJavaScriptFile();
        this.cpdTokens = this.sensorContext.newCpdTokens().onFile(this.inputFile.wrapped());
        super.visitFile(scriptTree);
    }

    @Override
    public void leaveFile(Tree scriptTree) {
        super.leaveFile(scriptTree);
        this.cpdTokens.save();
    }

    @Override
    public void visitNode(Tree tree) {
        if (((InternalSyntaxToken)tree).isEOF()) {
            return;
        }
        SyntaxToken token = (SyntaxToken)tree;
        String text = token.text();
        if (text.startsWith("\"") || text.startsWith("'") || text.startsWith("`")) {
            text = "LITERAL";
        }
        TextRange range = this.inputFile.newRange(token.line(), token.column(), token.endLine(), token.endColumn());
        this.cpdTokens.addToken(range, text);
    }
}

