/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.javascript.compat.CompatibleInputFile;
import org.sonar.javascript.lexer.JavaScriptKeyword;
import org.sonar.javascript.tree.impl.expression.LiteralTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FieldDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public class HighlighterVisitor
extends SubscriptionVisitor {
    private final SensorContext sensorContext;
    private NewHighlighting highlighting;
    private static final Tree.Kind[] METHODS = new Tree.Kind[]{Tree.Kind.GENERATOR_METHOD, Tree.Kind.METHOD, Tree.Kind.GET_METHOD, Tree.Kind.SET_METHOD};

    public HighlighterVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])METHODS).add((Object[])new Tree.Kind[]{Tree.Kind.FIELD, Tree.Kind.LET_DECLARATION, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.TEMPLATE_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.TOKEN}).build();
    }

    @Override
    public void visitFile(Tree scriptTree) {
        this.highlighting = this.sensorContext.newHighlighting().onFile(((CompatibleInputFile)this.getContext().getJavaScriptFile()).wrapped());
    }

    @Override
    public void leaveFile(Tree scriptTree) {
        this.highlighting.save();
    }

    @Override
    public void visitNode(Tree tree) {
        SyntaxToken token = null;
        TypeOfText code = null;
        if (tree.is(METHODS)) {
            token = ((MethodDeclarationTree)tree).staticToken();
            code = TypeOfText.KEYWORD;
        } else if (tree.is(Tree.Kind.FIELD)) {
            token = ((FieldDeclarationTree)tree).staticToken();
            code = TypeOfText.KEYWORD;
        } else if (tree.is(Tree.Kind.LET_DECLARATION)) {
            token = ((VariableDeclarationTree)tree).token();
            code = TypeOfText.KEYWORD;
        } else if (tree.is(Tree.Kind.TOKEN)) {
            this.highlightToken((InternalSyntaxToken)tree);
        } else if (tree.is(Tree.Kind.STRING_LITERAL)) {
            token = ((LiteralTreeImpl)tree).token();
            code = TypeOfText.STRING;
        } else if (tree.is(Tree.Kind.NUMERIC_LITERAL)) {
            token = ((LiteralTreeImpl)tree).token();
            code = TypeOfText.CONSTANT;
        } else if (tree.is(Tree.Kind.TEMPLATE_LITERAL)) {
            this.highlightTemplateLiteral((TemplateLiteralTree)tree);
        }
        if (token != null) {
            this.highlight(token, code);
        }
    }

    private void highlightTemplateLiteral(TemplateLiteralTree tree) {
        this.highlight(tree.openBacktick(), TypeOfText.STRING);
        this.highlight(tree.closeBacktick(), TypeOfText.STRING);
        for (TemplateCharactersTree templateCharactersTree : tree.strings()) {
            templateCharactersTree.characters().forEach(token -> this.highlight((SyntaxToken)token, TypeOfText.STRING));
        }
    }

    private void highlightToken(InternalSyntaxToken token) {
        if (HighlighterVisitor.isKeyword(token.text())) {
            this.highlight(token, TypeOfText.KEYWORD);
        }
        this.highlightComments(token);
    }

    private void highlightComments(InternalSyntaxToken token) {
        for (SyntaxTrivia trivia : token.trivias()) {
            TypeOfText type = trivia.text().startsWith("/**") ? TypeOfText.STRUCTURED_COMMENT : TypeOfText.COMMENT;
            this.highlight(trivia, type);
        }
    }

    private void highlight(SyntaxToken token, TypeOfText type) {
        this.highlighting.highlight(token.line(), token.column(), token.endLine(), token.endColumn(), type);
    }

    private static boolean isKeyword(String text) {
        for (String keyword : JavaScriptKeyword.keywordValues()) {
            if (!keyword.equals(text)) continue;
            return true;
        }
        return false;
    }
}

