/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Set;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class LocalVariables {
    private final Scope functionScope;
    private final Set<Symbol> trackableVariables = new HashSet<Symbol>();
    private final Set<Symbol> functionParameters = new HashSet<Symbol>();

    public LocalVariables(Scope functionScope, ControlFlowGraph cfg) {
        this.functionScope = functionScope;
        HashMultimap localVarIdentifiersInCfg = HashMultimap.create();
        for (CfgBlock block : cfg.blocks()) {
            for (Tree element : block.elements()) {
                if (!(element instanceof IdentifierTree)) continue;
                this.add((IdentifierTree)element, (SetMultimap<Symbol, IdentifierTree>)localVarIdentifiersInCfg);
            }
        }
        for (Symbol localVar : localVarIdentifiersInCfg.keySet()) {
            if (!LocalVariables.isWrittenOutsideCfg(localVar, (SetMultimap<Symbol, IdentifierTree>)localVarIdentifiersInCfg)) {
                this.trackableVariables.add(localVar);
            }
            if (!localVar.is(Symbol.Kind.PARAMETER)) continue;
            this.functionParameters.add(localVar);
        }
    }

    public Set<Symbol> trackableVariables() {
        return this.trackableVariables;
    }

    public Set<Symbol> functionParameters() {
        return this.functionParameters;
    }

    private static boolean isWrittenOutsideCfg(Symbol localVar, SetMultimap<Symbol, IdentifierTree> localVarIdentifiersInCfg) {
        for (Usage usage : localVar.usages()) {
            if (!usage.isWrite() || localVarIdentifiersInCfg.get((Object)localVar).contains(usage.identifierTree())) continue;
            return true;
        }
        return false;
    }

    private void add(IdentifierTree identifier, SetMultimap<Symbol, IdentifierTree> localVarIdentifiersInCfg) {
        Symbol symbol = identifier.symbol();
        if (symbol != null && this.isLocalVariable(symbol)) {
            localVarIdentifiersInCfg.put((Object)identifier.symbol(), (Object)identifier);
        }
    }

    private boolean isLocalVariable(Symbol symbol) {
        Scope scope = symbol.scope();
        while (!scope.isGlobal()) {
            if (scope.equals(this.functionScope)) {
                return true;
            }
            scope = scope.outer();
        }
        return false;
    }
}

