/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.sv.BuiltInFunctionSymbolicValue;
import org.sonar.javascript.se.sv.FunctionSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;

abstract class BuiltInProperty {
    public static final List<Constraint> ONE_NUMBER = ImmutableList.of((Object)Constraint.ANY_NUMBER);
    public static final List<Constraint> STRING_NUMBER = ImmutableList.of((Object)Constraint.ANY_STRING, (Object)Constraint.ANY_NUMBER);
    public static final List<Constraint> NUMBER_STRING = ImmutableList.of((Object)Constraint.ANY_NUMBER, (Object)Constraint.ANY_STRING);
    public static final List<Constraint> NUMBER_NUMBER = ImmutableList.of((Object)Constraint.ANY_NUMBER, (Object)Constraint.ANY_NUMBER);
    public static final List<Constraint> EMPTY = ImmutableList.of();
    public static final List<Constraint> ONE_STRING = ImmutableList.of((Object)Constraint.ANY_STRING);
    public static final IntFunction<Constraint> TO_LOCALE_STRING_SIGNATURE = parameterIndex -> {
        switch (parameterIndex) {
            case 0: {
                return Constraint.ANY_STRING.or(Constraint.ARRAY);
            }
            case 1: {
                return Constraint.OBJECT;
            }
        }
        return null;
    };

    BuiltInProperty() {
    }

    public abstract SymbolicValue access();

    public static BuiltInProperty property(Constraint constraint) {
        return new MutableBuiltinProperty(constraint);
    }

    public static Constraint constraintOnRecentProperty(Constraint baseConstraint) {
        return baseConstraint.or(Constraint.UNDEFINED);
    }

    protected static BuiltInProperty method(Constraint returnConstraint) {
        return BuiltInProperty.method(new BuiltInFunctionSymbolicValue(returnConstraint));
    }

    protected static BuiltInProperty method(Constraint returnConstraint, List<Constraint> parameterTypes) {
        return BuiltInProperty.method(returnConstraint, null, parameterTypes, false);
    }

    protected static BuiltInProperty method(Constraint returnConstraint, List<Constraint> parameterTypes, boolean hasSideEffect) {
        return BuiltInProperty.method(returnConstraint, null, parameterTypes, hasSideEffect);
    }

    protected static BuiltInProperty method(Constraint returnConstraint, IntFunction<Constraint> signature) {
        return BuiltInProperty.method(new BuiltInFunctionSymbolicValue(returnConstraint, signature, false));
    }

    protected static BuiltInProperty method(Constraint returnConstraint, IntFunction<Constraint> signature, boolean hasSideEffect) {
        return BuiltInProperty.method(new BuiltInFunctionSymbolicValue(returnConstraint, signature, hasSideEffect));
    }

    protected static BuiltInProperty method(Constraint returnConstraint, @Nullable BuiltInFunctionSymbolicValue.ArgumentsConstrainer argumentsConstrainer, List<Constraint> parameterTypes) {
        return BuiltInProperty.method(new BuiltInFunctionSymbolicValue(returnConstraint, argumentsConstrainer, new BuiltInFunctionSymbolicValue.ListSignature(parameterTypes), false));
    }

    protected static BuiltInProperty method(Constraint returnConstraint, @Nullable BuiltInFunctionSymbolicValue.ArgumentsConstrainer argumentsConstrainer, List<Constraint> parameterTypes, boolean hasSideEffect) {
        return BuiltInProperty.method(new BuiltInFunctionSymbolicValue(returnConstraint, argumentsConstrainer, new BuiltInFunctionSymbolicValue.ListSignature(parameterTypes), hasSideEffect));
    }

    private static BuiltInProperty method(BuiltInFunctionSymbolicValue builtInFunctionSymbolicValue) {
        return new BuiltinMethod(builtInFunctionSymbolicValue);
    }

    public static BuiltInFunctionSymbolicValue.ArgumentsConstrainer getIsSomethingArgumentsConstrainer(Constraint logicConstraint) {
        return (arguments, state, constraint2) -> {
            boolean hasArguments;
            boolean truthy = constraint2.isStricterOrEqualTo(Constraint.TRUTHY);
            boolean bl = hasArguments = !arguments.isEmpty();
            if (truthy && !hasArguments) {
                return Optional.empty();
            }
            if (truthy) {
                return state.constrain((SymbolicValue)arguments.get(0), logicConstraint);
            }
            if (!hasArguments) {
                return Optional.of(state);
            }
            return state.constrain((SymbolicValue)arguments.get(0), logicConstraint.not());
        };
    }

    private static class BuiltinMethod
    extends BuiltInProperty {
        private final FunctionSymbolicValue function;

        public BuiltinMethod(BuiltInFunctionSymbolicValue functionSymbolicValue) {
            this.function = functionSymbolicValue;
        }

        @Override
        public SymbolicValue access() {
            return this.function;
        }
    }

    private static class MutableBuiltinProperty
    extends BuiltInProperty {
        private final Constraint constraint;

        public MutableBuiltinProperty(Constraint constraint) {
            this.constraint = constraint;
        }

        @Override
        public SymbolicValue access() {
            return new SymbolicValueWithConstraint(this.constraint);
        }
    }
}

