/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.builtins.BuiltInProperty;

public class StringBuiltInProperties {
    private static final IntFunction<Constraint> localeCompareSignature = parameterIndex -> {
        switch (parameterIndex) {
            case 0: {
                return Constraint.ANY_STRING;
            }
            case 1: {
                return Constraint.ANY_STRING.or(Constraint.ARRAY);
            }
            case 2: {
                return Constraint.OBJECT;
            }
        }
        return null;
    };
    private static final IntFunction<Constraint> replaceSignature = parameterIndex -> {
        switch (parameterIndex) {
            case 0: {
                return Constraint.ANY_STRING.or(Constraint.REGEXP);
            }
            case 1: {
                return Constraint.ANY_STRING.or(Constraint.FUNCTION);
            }
        }
        return null;
    };
    private static final IntFunction<Constraint> numbersSignature = parameterIndex -> Constraint.ANY_NUMBER;
    public static final Map<String, BuiltInProperty> PROTOTYPE_PROPERTIES = ImmutableMap.builder().put((Object)"charAt", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_NUMBER)).put((Object)"charCodeAt", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, BuiltInProperty.ONE_NUMBER)).put((Object)"codePointAt", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, BuiltInProperty.ONE_NUMBER)).put((Object)"concat", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, parameterIndex -> Constraint.ANY_STRING)).put((Object)"includes", (Object)BuiltInProperty.method(Constraint.BOOLEAN_PRIMITIVE, BuiltInProperty.STRING_NUMBER)).put((Object)"endsWith", (Object)BuiltInProperty.method(Constraint.BOOLEAN_PRIMITIVE, BuiltInProperty.STRING_NUMBER)).put((Object)"indexOf", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, BuiltInProperty.STRING_NUMBER)).put((Object)"lastIndexOf", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, BuiltInProperty.STRING_NUMBER)).put((Object)"localeCompare", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, localeCompareSignature)).put((Object)"match", (Object)BuiltInProperty.method(Constraint.ARRAY.or(Constraint.NULL), (List<Constraint>)ImmutableList.of((Object)Constraint.REGEXP))).put((Object)"normalize", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_STRING)).put((Object)"padEnd", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.NUMBER_STRING)).put((Object)"padStart", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.NUMBER_STRING)).put((Object)"repeat", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_NUMBER)).put((Object)"replace", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, replaceSignature)).put((Object)"search", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, (List<Constraint>)ImmutableList.of((Object)Constraint.REGEXP))).put((Object)"slice", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.NUMBER_NUMBER)).put((Object)"split", (Object)BuiltInProperty.method(Constraint.ARRAY, (List<Constraint>)ImmutableList.of((Object)Constraint.ANY_STRING.or(Constraint.REGEXP), (Object)Constraint.ANY_NUMBER))).put((Object)"startsWith", (Object)BuiltInProperty.method(Constraint.BOOLEAN_PRIMITIVE, BuiltInProperty.STRING_NUMBER)).put((Object)"substr", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.NUMBER_NUMBER)).put((Object)"substring", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.NUMBER_NUMBER)).put((Object)"toLocaleLowerCase", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"toLocaleUpperCase", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"toLowerCase", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"toUpperCase", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"trim", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"length", (Object)BuiltInProperty.property(Constraint.POSITIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO))).put((Object)"toString", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"valueOf", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"anchor", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_STRING)).put((Object)"big", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"blink", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"bold", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"fixed", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"fontcolor", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_STRING)).put((Object)"fontsize", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_NUMBER)).put((Object)"italics", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"link", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_STRING)).put((Object)"small", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"strike", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"sub", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"sup", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"camelize", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"capitalize", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"classify", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"dasherize", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"decamelize", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"fmt", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"loc", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"underscore", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).put((Object)"w", (Object)BuiltInProperty.method(Constraint.ARRAY)).build();
    public static final Map<String, BuiltInProperty> PROPERTIES = ImmutableMap.builder().put((Object)"fromCharCode", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, numbersSignature)).put((Object)"fromCodePoint", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, numbersSignature)).put((Object)"raw", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE)).build();

    private StringBuiltInProperties() {
    }
}

