/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class BinaryExpressionTreeImpl
extends JavaScriptTree
implements BinaryExpressionTree,
TypableTree {
    private final ExpressionTree leftOperand;
    private final SyntaxToken operand;
    private final ExpressionTree rightOperand;
    private final Tree.Kind kind;
    private TypeSet types = TypeSet.emptyTypeSet();

    public BinaryExpressionTreeImpl(Tree.Kind kind, ExpressionTree leftOperand, InternalSyntaxToken operand, ExpressionTree rightOperand) {
        this.leftOperand = (ExpressionTree)Preconditions.checkNotNull((Object)leftOperand);
        this.operand = operand;
        this.rightOperand = (ExpressionTree)Preconditions.checkNotNull((Object)rightOperand);
        this.kind = (Tree.Kind)Preconditions.checkNotNull((Object)kind);
    }

    @Override
    public ExpressionTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public SyntaxToken operator() {
        return this.operand;
    }

    @Override
    public ExpressionTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.leftOperand, this.operand, this.rightOperand});
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    @Override
    public void add(Type type) {
        this.types.add(type);
    }
}

