/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class IdentifierTreeImpl
extends JavaScriptTree
implements IdentifierTree,
TypableTree {
    private final InternalSyntaxToken nameToken;
    private final Tree.Kind kind;
    private Symbol symbol = null;
    private TypeSet types = TypeSet.emptyTypeSet();
    private Scope scope;

    public IdentifierTreeImpl(Tree.Kind kind, InternalSyntaxToken nameToken) {
        this.kind = kind;
        this.nameToken = (InternalSyntaxToken)Preconditions.checkNotNull((Object)nameToken);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public SyntaxToken identifierToken() {
        return this.nameToken;
    }

    @Override
    public String name() {
        return this.identifierToken().text();
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public Symbol symbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public TypeSet types() {
        if (this.symbol == null) {
            return this.types.immutableCopy();
        }
        return this.symbol.types();
    }

    @Override
    public void add(Type type) {
        if (this.symbol == null) {
            this.types.add(type);
        } else {
            this.symbol.addType(type);
        }
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.nameToken);
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitIdentifier(this);
    }

    @Override
    public Scope scope() {
        return this.scope;
    }

    public void scope(Scope scope) {
        this.scope = scope;
    }

    @Override
    public List<IdentifierTree> bindingIdentifiers() {
        return ImmutableList.of((Object)this);
    }
}

