/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.visitors.SubscriptionTreeVisitor;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;

public class ComplexityVisitor
extends SubscriptionTreeVisitor {
    private int complexity;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.FUNCTION_DECLARATION), (Object)((Object)Tree.Kind.FUNCTION_EXPRESSION), (Object)((Object)Tree.Kind.METHOD), (Object)((Object)Tree.Kind.GENERATOR_METHOD), (Object)((Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION), (Object)((Object)Tree.Kind.GENERATOR_DECLARATION), (Object)((Object)Tree.Kind.IF_STATEMENT), (Object)((Object)Tree.Kind.DO_WHILE_STATEMENT), (Object)((Object)Tree.Kind.WHILE_STATEMENT), (Object)((Object)Tree.Kind.FOR_IN_STATEMENT), (Object)((Object)Tree.Kind.FOR_OF_STATEMENT), (Object)((Object)Tree.Kind.FOR_STATEMENT), (Object[])new Tree.Kind[]{Tree.Kind.CASE_CLAUSE, Tree.Kind.CATCH_BLOCK, Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.SET_METHOD, Tree.Kind.GET_METHOD});
    }

    public int getComplexity(Tree tree) {
        this.complexity = 0;
        this.scanTree(tree);
        return this.complexity;
    }

    @Override
    public void visitNode(Tree tree) {
        if (ComplexityVisitor.isStatementWithLastReturn(tree)) {
            --this.complexity;
        }
        if (!tree.is(Tree.Kind.SET_METHOD, Tree.Kind.GET_METHOD)) {
            ++this.complexity;
        }
    }

    private static boolean isStatementWithLastReturn(Tree tree) {
        Tree.Kind kind = ((JavaScriptTree)tree).getKind();
        boolean result = false;
        switch (kind) {
            case GET_METHOD: 
            case SET_METHOD: 
            case METHOD: 
            case GENERATOR_METHOD: {
                result = ComplexityVisitor.isLastReturn(((MethodDeclarationTree)tree).body().statements());
                break;
            }
            case GENERATOR_FUNCTION_EXPRESSION: 
            case FUNCTION_EXPRESSION: 
            case FUNCTION_DECLARATION: 
            case GENERATOR_DECLARATION: {
                result = ComplexityVisitor.isLastReturn(((FunctionTree)tree).body().statements());
                break;
            }
        }
        return result;
    }

    private static boolean isLastReturn(List<StatementTree> statements) {
        if (statements.isEmpty()) {
            return false;
        }
        StatementTree tree = statements.get(statements.size() - 1);
        return tree.is(Tree.Kind.RETURN_STATEMENT);
    }
}

