/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ContinueStatementTreeImpl
extends JavaScriptTree
implements ContinueStatementTree {
    private SyntaxToken continueKeyword;
    private final IdentifierTree label;
    private final SyntaxToken semicolonToken;

    public ContinueStatementTreeImpl(SyntaxToken semicolonToken) {
        this.label = null;
        this.semicolonToken = semicolonToken;
    }

    public ContinueStatementTreeImpl(IdentifierTree label, SyntaxToken semicolonToken) {
        this.label = label;
        this.semicolonToken = semicolonToken;
    }

    public ContinueStatementTreeImpl complete(InternalSyntaxToken continueKeyword) {
        Preconditions.checkState((this.continueKeyword == null ? 1 : 0) != 0, (Object)"Already completed");
        this.continueKeyword = continueKeyword;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONTINUE_STATEMENT;
    }

    @Override
    public SyntaxToken continueKeyword() {
        return this.continueKeyword;
    }

    @Override
    @Nullable
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.continueKeyword, this.label, this.semicolonToken});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitContinueStatement(this);
    }

    @Override
    @Nullable
    public SyntaxToken semicolonToken() {
        return this.semicolonToken;
    }
}

