/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.expression.IdentifierTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ClassTreeImpl
extends JavaScriptTree
implements ClassTree {
    private InternalSyntaxToken classToken;
    @Nullable
    private IdentifierTreeImpl name;
    @Nullable
    private InternalSyntaxToken extendsToken;
    @Nullable
    private ExpressionTree superClass;
    private InternalSyntaxToken openCurlyBraceToken;
    private final List<Tree> elements;
    private InternalSyntaxToken closeCurlyBraceToken;
    private final Tree.Kind kind;

    private ClassTreeImpl(Tree.Kind kind, InternalSyntaxToken classToken, @Nullable IdentifierTreeImpl name, @Nullable InternalSyntaxToken extendsToken, @Nullable ExpressionTree superClass, InternalSyntaxToken openCurlyBraceToken, List<Tree> elements, InternalSyntaxToken closeCurlyBraceToken) {
        this.kind = kind;
        this.classToken = classToken;
        this.name = name;
        this.extendsToken = extendsToken;
        this.superClass = superClass;
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.elements = elements;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
    }

    public static ClassTreeImpl newClassExpression(InternalSyntaxToken classToken, @Nullable IdentifierTreeImpl name, @Nullable InternalSyntaxToken extendsToken, @Nullable ExpressionTree superClass, InternalSyntaxToken openCurlyBraceToken, List<Tree> elements, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassTreeImpl(Tree.Kind.CLASS_EXPRESSION, classToken, name, extendsToken, superClass, openCurlyBraceToken, elements, closeCurlyBraceToken);
    }

    public static ClassTreeImpl newClassDeclaration(InternalSyntaxToken classToken, @Nullable IdentifierTreeImpl name, @Nullable InternalSyntaxToken extendsToken, @Nullable ExpressionTree superClass, InternalSyntaxToken openCurlyBraceToken, List<Tree> elements, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassTreeImpl(Tree.Kind.CLASS_DECLARATION, classToken, name, extendsToken, superClass, openCurlyBraceToken, elements, closeCurlyBraceToken);
    }

    @Override
    public SyntaxToken classToken() {
        return this.classToken;
    }

    @Override
    public IdentifierTree name() {
        return this.name;
    }

    @Override
    @Nullable
    public SyntaxToken extendsToken() {
        return this.extendsToken;
    }

    @Override
    @Nullable
    public ExpressionTree superClass() {
        return this.superClass;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public List<Tree> elements() {
        return this.elements;
    }

    @Override
    public Iterable<MethodDeclarationTree> methods() {
        return Iterables.filter(this.elements, MethodDeclarationTree.class);
    }

    @Override
    public Iterable<SyntaxToken> semicolons() {
        return Iterables.filter(this.elements, SyntaxToken.class);
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.forArray((Object[])new Tree[]{this.classToken, this.name, this.extendsToken, this.superClass, this.openCurlyBraceToken}), this.elements.iterator(), (Iterator)Iterators.singletonIterator((Object)this.closeCurlyBraceToken));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitClassDeclaration(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

