/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.cfg.JsCfgBlock;
import org.sonar.javascript.cfg.JsCfgBranchingBlock;
import org.sonar.javascript.cfg.JsCfgEndBlock;
import org.sonar.javascript.cfg.JsCfgForwardingBlock;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ArrayBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ComputedPropertyNameTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.SpreadElementTree;
import org.sonar.plugins.javascript.api.tree.expression.TaggedTemplateTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;

class ControlFlowGraphBuilder {
    private final Set<JsCfgBlock> blocks = new HashSet<JsCfgBlock>();
    private final JsCfgEndBlock end = new JsCfgEndBlock();
    private JsCfgBlock currentBlock = this.createSimpleBlock(this.end);
    private JsCfgBlock start;
    private final Deque<Breakable> breakables = new ArrayDeque<Breakable>();
    private final Deque<JsCfgBlock> throwTargets = new ArrayDeque<JsCfgBlock>();
    private String currentLabel = null;
    private static final Tree.Kind[] SIMPLE_BINARY_KINDS = new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.EXPONENT, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.RELATIONAL_IN, Tree.Kind.INSTANCE_OF, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_XOR, Tree.Kind.BITWISE_OR, Tree.Kind.COMMA_OPERATOR};
    private static final Tree.Kind[] UNARY_KINDS = new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.DELETE, Tree.Kind.VOID, Tree.Kind.TYPEOF, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.AWAIT};

    ControlFlowGraphBuilder() {
    }

    ControlFlowGraph createGraph(ScriptTree tree) {
        Object items = ImmutableList.of();
        if (tree.items() != null) {
            items = tree.items().items();
        }
        return this.createGraph((List<? extends Tree>)items);
    }

    ControlFlowGraph createGraph(BlockTree body) {
        return this.createGraph(body.statements());
    }

    private ControlFlowGraph createGraph(List<? extends Tree> items) {
        this.throwTargets.push(this.end);
        this.build(items);
        this.start = this.currentBlock;
        this.removeEmptyBlocks();
        this.blocks.add(this.end);
        return new ControlFlowGraph(this.blocks, this.start, this.end);
    }

    private void removeEmptyBlocks() {
        HashMap<JsCfgBlock, JsCfgBlock> emptyBlockReplacements = new HashMap<JsCfgBlock, JsCfgBlock>();
        for (JsCfgBlock block : this.blocks) {
            if (!block.elements().isEmpty()) continue;
            JsCfgBlock firstNonEmptySuccessor = block.skipEmptyBlocks();
            emptyBlockReplacements.put(block, firstNonEmptySuccessor);
            for (SyntaxToken jump : block.disconnectingJumps()) {
                firstNonEmptySuccessor.addDisconnectingJump(jump);
            }
        }
        this.blocks.removeAll(emptyBlockReplacements.keySet());
        for (JsCfgBlock block : this.blocks) {
            block.replaceSuccessors(emptyBlockReplacements);
        }
        if (emptyBlockReplacements.containsKey(this.start)) {
            this.start = (JsCfgBlock)emptyBlockReplacements.get(this.start);
        }
    }

    private void build(List<? extends Tree> trees) {
        for (Tree tree : Lists.reverse(trees)) {
            this.build(tree);
        }
    }

    private void build(Tree tree) {
        if (tree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            this.buildExpression(((ExpressionStatementTree)tree).expression());
        } else if (tree.is(Tree.Kind.VARIABLE_STATEMENT)) {
            this.buildExpression(((VariableStatementTree)tree).declaration());
        } else if (tree.is(Tree.Kind.IF_STATEMENT)) {
            this.visitIfStatement((IfStatementTree)tree);
        } else if (tree.is(Tree.Kind.FOR_STATEMENT)) {
            this.visitForStatement((ForStatementTree)tree);
        } else if (tree.is(Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT)) {
            this.visitForObjectStatement((ForObjectStatementTree)tree);
        } else if (tree.is(Tree.Kind.WHILE_STATEMENT)) {
            this.visitWhileStatement((WhileStatementTree)tree);
        } else if (tree.is(Tree.Kind.DO_WHILE_STATEMENT)) {
            this.visitDoWhileStatement((DoWhileStatementTree)tree);
        } else if (tree.is(Tree.Kind.CONTINUE_STATEMENT)) {
            this.visitContinueStatement((ContinueStatementTree)tree);
        } else if (tree.is(Tree.Kind.BREAK_STATEMENT)) {
            this.visitBreakStatement((BreakStatementTree)tree);
        } else if (tree.is(Tree.Kind.RETURN_STATEMENT)) {
            this.visitReturnStatement((ReturnStatementTree)tree);
        } else if (tree.is(Tree.Kind.BLOCK)) {
            this.visitBlock((BlockTree)tree);
        } else if (tree.is(Tree.Kind.LABELLED_STATEMENT)) {
            this.visitLabelledStatement((LabelledStatementTree)tree);
        } else if (tree.is(Tree.Kind.TRY_STATEMENT)) {
            this.visitTryStatement((TryStatementTree)tree);
        } else if (tree.is(Tree.Kind.THROW_STATEMENT)) {
            this.visitThrowStatement((ThrowStatementTree)tree);
        } else if (tree.is(Tree.Kind.SWITCH_STATEMENT)) {
            this.visitSwitchStatement((SwitchStatementTree)tree);
        } else if (tree.is(Tree.Kind.WITH_STATEMENT)) {
            WithStatementTree with = (WithStatementTree)tree;
            this.build(with.statement());
            this.buildExpression(with.expression());
        } else if (tree.is(Tree.Kind.DEBUGGER_STATEMENT, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.CLASS_DECLARATION, Tree.Kind.IMPORT_DECLARATION, Tree.Kind.IMPORT_MODULE_DECLARATION, Tree.Kind.DEFAULT_EXPORT_DECLARATION, Tree.Kind.NAMED_EXPORT_DECLARATION, Tree.Kind.NAMESPACE_EXPORT_DECLARATION)) {
            this.currentBlock.addElement(tree);
        } else if (!tree.is(Tree.Kind.EMPTY_STATEMENT)) {
            throw new IllegalArgumentException("Cannot build CFG for " + tree);
        }
    }

    private void buildExpressions(List<? extends Tree> expressions) {
        for (Tree expression : Lists.reverse(expressions)) {
            this.buildExpression(expression);
        }
    }

    private void buildExpression(Tree tree) {
        if (!tree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            this.currentBlock.addElement(tree);
        }
        if (tree.is(SIMPLE_BINARY_KINDS)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            this.buildExpression(binary.rightOperand());
            this.buildExpression(binary.leftOperand());
        } else if (tree.is(KindSet.ASSIGNMENT_KINDS)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
            this.buildExpression(assignment.expression());
            this.buildExpression(assignment.variable());
        } else if (tree.is(UNARY_KINDS)) {
            UnaryExpressionTree unary = (UnaryExpressionTree)tree;
            this.buildExpression(unary.expression());
        } else if (tree.is(Tree.Kind.ARRAY_LITERAL)) {
            ArrayLiteralTree arrayLiteral = (ArrayLiteralTree)tree;
            this.buildExpressions(arrayLiteral.elements());
        } else if (tree.is(Tree.Kind.OBJECT_LITERAL)) {
            ObjectLiteralTree objectLiteral = (ObjectLiteralTree)tree;
            this.buildExpressions(objectLiteral.properties());
        } else if (tree.is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
            MemberExpressionTree memberExpression = (MemberExpressionTree)tree;
            this.buildExpression(memberExpression.object());
        } else if (tree.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION)) {
            MemberExpressionTree memberExpression = (MemberExpressionTree)tree;
            this.buildExpression(memberExpression.property());
            this.buildExpression(memberExpression.object());
        } else if (tree.is(Tree.Kind.CALL_EXPRESSION)) {
            CallExpressionTree callExpression = (CallExpressionTree)tree;
            this.buildExpressions(callExpression.argumentClause().arguments());
            this.buildExpression(callExpression.callee());
        } else if (tree.is(Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION)) {
            VariableDeclarationTree declaration = (VariableDeclarationTree)tree;
            this.buildExpressions(declaration.variables());
        } else if (tree.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
            InitializedBindingElementTree initializedBindingElementTree = (InitializedBindingElementTree)tree;
            this.buildExpression(initializedBindingElementTree.left());
            this.buildExpression(initializedBindingElementTree.right());
        } else if (tree.is(Tree.Kind.PAIR_PROPERTY)) {
            PairPropertyTree pairProperty = (PairPropertyTree)tree;
            this.buildExpression(pairProperty.value());
            this.buildExpression(pairProperty.key());
        } else if (tree.is(Tree.Kind.COMPUTED_PROPERTY_NAME)) {
            ComputedPropertyNameTree computedPropertyName = (ComputedPropertyNameTree)tree;
            this.buildExpression(computedPropertyName.expression());
        } else if (tree.is(Tree.Kind.NEW_EXPRESSION)) {
            NewExpressionTree newExpression = (NewExpressionTree)tree;
            if (newExpression.argumentClause() != null) {
                this.buildExpressions(newExpression.argumentClause().arguments());
            }
            this.buildExpression(newExpression.expression());
        } else if (tree.is(Tree.Kind.CONDITIONAL_AND)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            JsCfgBlock falseSuccessor = (JsCfgBlock)ControlFlowGraph.falseSuccessorFor(this.currentBlock);
            if (!this.currentBlock.elements().isEmpty()) {
                falseSuccessor = this.currentBlock;
                this.currentBlock = this.createSimpleBlock(this.currentBlock);
            }
            this.buildExpression(binary.rightOperand());
            JsCfgBlock trueSuccessor = this.currentBlock;
            this.currentBlock = this.createBranchingBlock(tree, this.currentBlock, falseSuccessor);
            this.buildCondition(binary.leftOperand(), trueSuccessor, falseSuccessor);
        } else if (tree.is(Tree.Kind.CONDITIONAL_OR)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            JsCfgBlock trueSuccessor = (JsCfgBlock)ControlFlowGraph.trueSuccessorFor(this.currentBlock);
            if (!this.currentBlock.elements().isEmpty()) {
                trueSuccessor = this.currentBlock;
                this.currentBlock = this.createSimpleBlock(this.currentBlock);
            }
            this.buildExpression(binary.rightOperand());
            JsCfgBlock falseSuccessor = this.currentBlock;
            this.currentBlock = this.createBranchingBlock(tree, trueSuccessor, this.currentBlock);
            this.buildCondition(binary.leftOperand(), trueSuccessor, falseSuccessor);
        } else if (tree.is(Tree.Kind.CONDITIONAL_EXPRESSION)) {
            ConditionalExpressionTree conditionalExpression = (ConditionalExpressionTree)tree;
            JsCfgBlock successor = this.currentBlock;
            this.currentBlock = this.createSimpleBlock(successor);
            this.buildExpression(conditionalExpression.falseExpression());
            JsCfgBlock falseBlock = this.currentBlock;
            this.currentBlock = this.createSimpleBlock(successor);
            this.buildExpression(conditionalExpression.trueExpression());
            JsCfgBlock trueBlock = this.currentBlock;
            this.currentBlock = this.createBranchingBlock(tree, trueBlock, falseBlock);
            this.buildCondition(conditionalExpression.condition(), trueBlock, falseBlock);
        } else if (tree.is(Tree.Kind.SPREAD_ELEMENT)) {
            SpreadElementTree spreadElement = (SpreadElementTree)tree;
            this.buildExpression(spreadElement.element());
        } else if (tree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            ParenthesisedExpressionTree parenthesisedExpression = (ParenthesisedExpressionTree)tree;
            this.buildExpression(parenthesisedExpression.expression());
        } else if (tree.is(Tree.Kind.TEMPLATE_LITERAL)) {
            TemplateLiteralTree templateLiteral = (TemplateLiteralTree)tree;
            this.buildExpressions(templateLiteral.expressions());
        } else if (tree.is(Tree.Kind.TEMPLATE_EXPRESSION)) {
            TemplateExpressionTree templateExpression = (TemplateExpressionTree)tree;
            this.buildExpression(templateExpression.expression());
        } else if (tree.is(Tree.Kind.TAGGED_TEMPLATE)) {
            TaggedTemplateTree taggedTemplate = (TaggedTemplateTree)tree;
            this.buildExpression(taggedTemplate.template());
            this.buildExpression(taggedTemplate.callee());
        } else if (tree.is(Tree.Kind.YIELD_EXPRESSION)) {
            YieldExpressionTree yieldExpression = (YieldExpressionTree)tree;
            if (yieldExpression.argument() != null) {
                this.buildExpression(yieldExpression.argument());
            }
        } else if (tree.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
            ObjectBindingPatternTree objectBindingPattern = (ObjectBindingPatternTree)tree;
            this.buildExpressions(objectBindingPattern.elements());
        } else if (tree.is(Tree.Kind.BINDING_PROPERTY)) {
            BindingPropertyTree bindingProperty = (BindingPropertyTree)tree;
            this.buildExpression(bindingProperty.value());
        } else if (tree.is(Tree.Kind.REST_ELEMENT)) {
            RestElementTree restElement = (RestElementTree)tree;
            this.buildExpression(restElement.element());
        } else if (tree.is(Tree.Kind.ARRAY_BINDING_PATTERN)) {
            ArrayBindingPatternTree arrayBindingPattern = (ArrayBindingPatternTree)tree;
            for (Optional element : Lists.reverse(arrayBindingPattern.elements())) {
                if (!element.isPresent()) continue;
                this.buildExpression((Tree)element.get());
            }
        }
    }

    private void buildCondition(ExpressionTree expression, JsCfgBlock trueBlock, JsCfgBlock falseBlock) {
        JsCfgBlock trueSuccessor = trueBlock;
        JsCfgBlock falseSuccessor = falseBlock;
        if (expression.is(Tree.Kind.CONDITIONAL_AND)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)expression;
            this.buildCondition(binary.rightOperand(), trueSuccessor, falseSuccessor);
            trueSuccessor = this.currentBlock;
            this.currentBlock = this.createBranchingBlock(expression, trueSuccessor, falseSuccessor);
            this.buildCondition(binary.leftOperand(), trueSuccessor, falseSuccessor);
        } else if (expression.is(Tree.Kind.CONDITIONAL_OR)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)expression;
            this.buildCondition(binary.rightOperand(), trueSuccessor, falseSuccessor);
            falseSuccessor = this.currentBlock;
            this.currentBlock = this.createBranchingBlock(expression, trueSuccessor, falseSuccessor);
            this.buildCondition(binary.leftOperand(), trueSuccessor, falseSuccessor);
        } else if (expression.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            this.buildCondition(((ParenthesisedExpressionTree)expression).expression(), trueSuccessor, falseSuccessor);
        } else {
            this.buildExpression(expression);
        }
    }

    private void visitBlock(BlockTree block) {
        this.build(block.statements());
    }

    private void addBreakable(JsCfgBlock breakTarget, @Nullable JsCfgBlock continueTarget, @Nullable String label) {
        this.breakables.addFirst(new Breakable(continueTarget, breakTarget, label));
    }

    private void removeBreakable() {
        this.breakables.removeFirst();
    }

    private void visitReturnStatement(ReturnStatementTree tree) {
        this.currentBlock.addDisconnectingJump(tree.returnKeyword());
        this.currentBlock = this.createSimpleBlock(tree, this.end);
        if (tree.expression() != null) {
            this.buildExpression(tree.expression());
        }
    }

    private void visitContinueStatement(ContinueStatementTree tree) {
        JsCfgBlock target = null;
        String label = tree.labelToken() == null ? null : tree.labelToken().text();
        for (Breakable breakable : this.breakables) {
            if (breakable.continueTarget == null || label != null && !label.equals(breakable.label)) continue;
            target = breakable.continueTarget;
            break;
        }
        if (target == null) {
            ControlFlowGraphBuilder.raiseRecognitionException(tree, "continue", label);
        }
        this.currentBlock.addDisconnectingJump(tree.continueKeyword());
        this.currentBlock = this.createSimpleBlock(tree, target);
    }

    private void visitBreakStatement(BreakStatementTree tree) {
        JsCfgBlock target = null;
        String label = tree.labelToken() == null ? null : tree.labelToken().text();
        for (Breakable breakable : this.breakables) {
            if (label != null && !label.equals(breakable.label)) continue;
            target = breakable.breakTarget;
            break;
        }
        if (target == null) {
            ControlFlowGraphBuilder.raiseRecognitionException(tree, "break", label);
        }
        this.currentBlock.addDisconnectingJump(tree.breakKeyword());
        this.currentBlock = this.createSimpleBlock(tree, target);
    }

    private static void raiseRecognitionException(Tree tree, String type, @Nullable String label) {
        int line = tree.firstToken().line();
        String message = "No '" + type + "' target can be found at line " + line;
        if (label != null) {
            message = message + " (label '" + label + "')";
        }
        throw new RecognitionException(line, message);
    }

    private void visitIfStatement(IfStatementTree tree) {
        JsCfgBlock successor = this.currentBlock;
        if (tree.elseClause() != null) {
            this.buildSubFlow(tree.elseClause().statement(), successor);
        }
        JsCfgBlock elseBlock = this.currentBlock;
        this.buildSubFlow(tree.statement(), successor);
        JsCfgBlock thenBlock = this.currentBlock;
        JsCfgBranchingBlock branchingBlock = this.createBranchingBlock(tree, thenBlock, elseBlock);
        this.currentBlock = branchingBlock;
        this.buildCondition(tree.condition(), thenBlock, elseBlock);
    }

    private void visitForStatement(ForStatementTree tree) {
        JsCfgBlock forStatementSuccessor = this.currentBlock;
        JsCfgForwardingBlock linkToCondition = this.createForwardingBlock();
        JsCfgForwardingBlock linkToUpdate = this.createForwardingBlock();
        JsCfgBlock loopBodyBlock = this.buildLoopBody(tree.statement(), linkToUpdate, this.currentBlock);
        if (tree.update() != null) {
            this.currentBlock = this.createSimpleBlock(linkToCondition);
            this.buildExpression(tree.update());
            linkToUpdate.setSuccessor(this.currentBlock);
        } else {
            linkToUpdate.setSuccessor(linkToCondition);
        }
        if (tree.condition() != null) {
            this.currentBlock = this.createBranchingBlock(tree, loopBodyBlock, forStatementSuccessor);
            this.buildCondition(tree.condition(), loopBodyBlock, forStatementSuccessor);
            linkToCondition.setSuccessor(this.currentBlock);
        } else {
            linkToCondition.setSuccessor(loopBodyBlock);
        }
        this.currentBlock = this.createSimpleBlock(linkToCondition);
        if (tree.init() != null) {
            this.buildExpression(tree.init());
        } else if (tree.condition() == null && loopBodyBlock.elements().isEmpty()) {
            loopBodyBlock.addElement(tree.forKeyword());
        }
    }

    private void visitForObjectStatement(ForObjectStatementTree tree) {
        JsCfgBlock successor = this.currentBlock;
        JsCfgForwardingBlock linkToAssignment = this.createForwardingBlock();
        JsCfgBlock loopBodyBlock = this.buildLoopBody(tree.statement(), linkToAssignment, this.currentBlock);
        JsCfgBranchingBlock assignmentBlock = this.createBranchingBlock(tree, loopBodyBlock, successor);
        this.currentBlock = assignmentBlock;
        this.buildExpression(tree.variableOrExpression());
        this.buildExpression(tree.expression());
        linkToAssignment.setSuccessor(this.currentBlock);
        this.currentBlock = this.createSimpleBlock(this.currentBlock);
    }

    private void visitWhileStatement(WhileStatementTree tree) {
        JsCfgBlock successor = this.currentBlock;
        JsCfgForwardingBlock linkToCondition = this.createForwardingBlock();
        JsCfgBlock loopBodyBlock = this.buildLoopBody(tree.statement(), linkToCondition, successor);
        this.currentBlock = this.createBranchingBlock(tree, loopBodyBlock, successor);
        this.buildCondition(tree.condition(), loopBodyBlock, successor);
        linkToCondition.setSuccessor(this.currentBlock);
        this.currentBlock = this.createSimpleBlock(this.currentBlock);
    }

    private void visitDoWhileStatement(DoWhileStatementTree tree) {
        JsCfgBlock successor = this.currentBlock;
        JsCfgForwardingBlock linkToBody = this.createForwardingBlock();
        this.currentBlock = this.createBranchingBlock(tree, linkToBody, successor);
        this.buildCondition(tree.condition(), linkToBody, successor);
        JsCfgBlock loopBodyBlock = this.buildLoopBody(tree.statement(), this.currentBlock, successor);
        linkToBody.setSuccessor(loopBodyBlock);
        this.currentBlock = this.createSimpleBlock(loopBodyBlock);
    }

    private void visitLabelledStatement(LabelledStatementTree tree) {
        String label = tree.labelToken().text();
        boolean isLoopStatement = tree.statement().is(KindSet.LOOP_KINDS);
        if (!isLoopStatement) {
            this.addBreakable(this.currentBlock, null, label);
            this.currentBlock = this.createSimpleBlock(this.currentBlock);
        } else {
            this.currentLabel = label;
        }
        this.build(tree.statement());
        if (!isLoopStatement) {
            this.removeBreakable();
        }
    }

    private void visitTryStatement(TryStatementTree tree) {
        JsCfgBlock catchOrFinallyBlock = null;
        if (tree.finallyBlock() != null) {
            this.currentBlock = this.createSimpleBlock(this.currentBlock);
            this.build(tree.finallyBlock().block());
            this.throwTargets.push(this.currentBlock);
            catchOrFinallyBlock = this.currentBlock;
        }
        if (tree.catchBlock() != null) {
            JsCfgBlock catchSuccessor = this.currentBlock;
            this.buildSubFlow(tree.catchBlock().block(), this.currentBlock);
            JsCfgBranchingBlock catchBlock = this.createBranchingBlock(tree.catchBlock(), this.currentBlock, catchSuccessor);
            this.currentBlock = catchBlock;
            this.buildExpression(tree.catchBlock().parameter());
            catchOrFinallyBlock = catchBlock;
            this.currentBlock = catchBlock;
        }
        if (tree.finallyBlock() != null) {
            this.throwTargets.pop();
        }
        this.throwTargets.push(this.currentBlock);
        this.currentBlock = this.createSimpleBlock(this.currentBlock);
        this.build(tree.block());
        this.throwTargets.pop();
        this.currentBlock = this.createBranchingBlock(tree, this.currentBlock, catchOrFinallyBlock);
        this.currentBlock.addElement(tree.tryKeyword());
    }

    private void visitThrowStatement(ThrowStatementTree tree) {
        this.currentBlock.addDisconnectingJump(tree.throwKeyword());
        this.currentBlock = this.createSimpleBlock(this.throwTargets.peek());
        this.buildExpression(tree.expression());
    }

    private void visitSwitchStatement(SwitchStatementTree tree) {
        this.addBreakable(this.currentBlock, null, null);
        JsCfgBlock nextStatementBlock = this.currentBlock;
        JsCfgForwardingBlock defaultForwardingBlock = this.createForwardingBlock();
        defaultForwardingBlock.setSuccessor(this.currentBlock);
        JsCfgBlock nextCase = defaultForwardingBlock;
        for (SwitchClauseTree switchCaseClause : Lists.reverse(tree.cases())) {
            if (switchCaseClause.is(Tree.Kind.CASE_CLAUSE)) {
                this.currentBlock = this.createSimpleBlock(nextStatementBlock);
                this.build(switchCaseClause.statements());
                if (!switchCaseClause.statements().isEmpty()) {
                    nextStatementBlock = this.currentBlock;
                }
                CaseClauseTree caseClause = (CaseClauseTree)switchCaseClause;
                this.currentBlock = this.createBranchingBlock(caseClause, nextStatementBlock, nextCase);
                this.buildExpression(caseClause.expression());
                nextCase = this.currentBlock;
                continue;
            }
            this.currentBlock = this.createSimpleBlock(nextStatementBlock);
            this.build(switchCaseClause.statements());
            defaultForwardingBlock.setSuccessor(this.currentBlock);
            if (switchCaseClause.statements().isEmpty()) continue;
            nextStatementBlock = this.currentBlock;
        }
        this.removeBreakable();
        this.currentBlock = this.createSimpleBlock(nextCase);
        this.buildExpression(tree.expression());
    }

    private JsCfgBlock buildLoopBody(StatementTree body, JsCfgBlock conditionBlock, JsCfgBlock breakTarget) {
        this.addBreakable(breakTarget, conditionBlock, this.currentLabel);
        this.currentLabel = null;
        this.buildSubFlow(body, conditionBlock);
        JsCfgBlock loopBodyBlock = this.currentBlock;
        this.removeBreakable();
        return loopBodyBlock;
    }

    private void buildSubFlow(StatementTree subFlowTree, JsCfgBlock successor) {
        this.currentBlock = this.createSimpleBlock(successor);
        this.build(subFlowTree);
    }

    private JsCfgBranchingBlock createBranchingBlock(Tree branchingTree, JsCfgBlock trueSuccessor, JsCfgBlock falseSuccessor) {
        JsCfgBranchingBlock block = new JsCfgBranchingBlock(branchingTree, trueSuccessor, falseSuccessor);
        this.blocks.add(block);
        return block;
    }

    private JsCfgBlock createSimpleBlock(Tree element, JsCfgBlock successor) {
        JsCfgBlock block = this.createSimpleBlock(successor);
        block.addElement(element);
        return block;
    }

    private JsCfgBlock createSimpleBlock(JsCfgBlock successor) {
        JsCfgBlock block = new JsCfgBlock(successor);
        this.blocks.add(block);
        return block;
    }

    private JsCfgForwardingBlock createForwardingBlock() {
        JsCfgForwardingBlock block = new JsCfgForwardingBlock();
        this.blocks.add(block);
        return block;
    }

    private static class Breakable {
        @CheckForNull
        final JsCfgBlock continueTarget;
        final JsCfgBlock breakTarget;
        @CheckForNull
        final String label;

        Breakable(@Nullable JsCfgBlock continueTarget, JsCfgBlock breakTarget, @Nullable String label) {
            this.continueTarget = continueTarget;
            this.breakTarget = breakTarget;
            this.label = label;
        }
    }
}

