/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.declaration;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ParameterListTreeImpl
extends JavaScriptTree
implements ParameterListTree {
    private InternalSyntaxToken openParenthesis;
    private final SeparatedList<BindingElementTree> parameters;
    private InternalSyntaxToken closeParenthesis;
    private final Tree.Kind kind;

    public ParameterListTreeImpl(InternalSyntaxToken openParenthesis, SeparatedList<BindingElementTree> parameters, InternalSyntaxToken closeParenthesis) {
        this.openParenthesis = openParenthesis;
        this.parameters = parameters;
        this.closeParenthesis = closeParenthesis;
        this.kind = Tree.Kind.PARAMETER_LIST;
    }

    @Override
    public SyntaxToken openParenthesisToken() {
        return this.openParenthesis;
    }

    @Override
    public SeparatedList<BindingElementTree> parameters() {
        return this.parameters;
    }

    @Override
    public SyntaxToken closeParenthesisToken() {
        return this.closeParenthesis;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openParenthesis), this.parameters.elementsAndSeparators((Function<BindingElementTree, Tree>)Functions.identity()), (Iterator)Iterators.singletonIterator((Object)this.closeParenthesis));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitParameterList(this);
    }

    public List<IdentifierTree> parameterIdentifiers() {
        ArrayList identifiers = Lists.newArrayList();
        for (Tree tree : this.parameters) {
            if (tree.is(Tree.Kind.BINDING_IDENTIFIER)) {
                identifiers.add((IdentifierTree)tree);
                continue;
            }
            if (tree.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                identifiers.addAll(((InitializedBindingElementTreeImpl)tree).bindingIdentifiers());
                continue;
            }
            if (tree.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
                identifiers.addAll(((ObjectBindingPatternTreeImpl)tree).bindingIdentifiers());
                continue;
            }
            if (tree.is(Tree.Kind.REST_ELEMENT)) {
                identifiers.add((IdentifierTree)((RestElementTree)tree).element());
                continue;
            }
            identifiers.addAll(((ArrayBindingPatternTreeImpl)tree).bindingIdentifiers());
        }
        return identifiers;
    }
}

