/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ArrayLiteralTreeImpl
extends JavaScriptTree
implements ArrayLiteralTree,
TypableTree {
    private final List<ExpressionTree> elements;
    private final SyntaxToken openBracket;
    private final List<Tree> elementsAndCommas;
    private final SyntaxToken closeBracket;
    private TypeSet types = TypeSet.emptyTypeSet();

    public ArrayLiteralTreeImpl(SyntaxToken openBracket, List<Tree> elementsAndCommas, SyntaxToken closeBracket) {
        this.openBracket = openBracket;
        this.elementsAndCommas = elementsAndCommas;
        this.closeBracket = closeBracket;
        this.elements = elementsAndCommas.stream().filter(x -> !x.is(Tree.Kind.TOKEN)).map(element -> (ExpressionTree)element).collect(Collectors.toList());
    }

    @Override
    public SyntaxToken openBracketToken() {
        return this.openBracket;
    }

    @Override
    public List<ExpressionTree> elements() {
        return this.elements;
    }

    @Override
    public List<Tree> elementsAndCommas() {
        return this.elementsAndCommas;
    }

    @Override
    public SyntaxToken closeBracketToken() {
        return this.closeBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_LITERAL;
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    @Override
    public void add(Type type) {
        this.types.add(type);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openBracket), this.elementsAndCommas.iterator(), (Iterator)Iterators.singletonIterator((Object)this.closeBracket));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitArrayLiteral(this);
    }
}

