/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.typed.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.javascript.lexer.JavaScriptKeyword;
import org.sonar.javascript.lexer.JavaScriptPunctuator;
import org.sonar.javascript.tree.impl.SeparatedListImpl;
import org.sonar.javascript.tree.impl.declaration.AccessorMethodDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.declaration.BindingPropertyTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ClassTreeImpl;
import org.sonar.javascript.tree.impl.declaration.DecoratorTreeImpl;
import org.sonar.javascript.tree.impl.declaration.DefaultExportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ExportClauseTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ExportDefaultBindingImpl;
import org.sonar.javascript.tree.impl.declaration.ExportDefaultBindingWithExportListImpl;
import org.sonar.javascript.tree.impl.declaration.ExportDefaultBindingWithNameSpaceExportImpl;
import org.sonar.javascript.tree.impl.declaration.ExtendsClauseTreeImpl;
import org.sonar.javascript.tree.impl.declaration.FieldDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.FromClauseTreeImpl;
import org.sonar.javascript.tree.impl.declaration.FunctionDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ImportClauseTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ImportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ImportModuleDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.tree.impl.declaration.MethodDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ModuleTreeImpl;
import org.sonar.javascript.tree.impl.declaration.NameSpaceExportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.NameSpaceSpecifierTreeImpl;
import org.sonar.javascript.tree.impl.declaration.NamedExportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ScriptTreeImpl;
import org.sonar.javascript.tree.impl.declaration.SpecifierListTreeImpl;
import org.sonar.javascript.tree.impl.declaration.SpecifierTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArgumentListTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrayAssignmentPatternTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrayLiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrowFunctionTreeImpl;
import org.sonar.javascript.tree.impl.expression.AssignmentExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.AssignmentPatternRestElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.BinaryExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.BracketMemberExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.CallExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.ComputedPropertyNameTreeImpl;
import org.sonar.javascript.tree.impl.expression.ConditionalExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.DotMemberExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.FunctionExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.IdentifierTreeImpl;
import org.sonar.javascript.tree.impl.expression.InitializedAssignmentPatternElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.LiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.NewExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.NewTargetTreeImpl;
import org.sonar.javascript.tree.impl.expression.ObjectAssignmentPatternPairElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.ObjectAssignmentPatternTreeImpl;
import org.sonar.javascript.tree.impl.expression.ObjectLiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.PairPropertyTreeImpl;
import org.sonar.javascript.tree.impl.expression.ParenthesisedExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.PostfixExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.PrefixExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.RestElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.SpreadElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.SuperTreeImpl;
import org.sonar.javascript.tree.impl.expression.TaggedTemplateTreeImpl;
import org.sonar.javascript.tree.impl.expression.TemplateCharactersTreeImpl;
import org.sonar.javascript.tree.impl.expression.TemplateExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.TemplateLiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.YieldExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxClosingElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxIdentifierTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxJavaScriptExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxOpeningElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxSelfClosingElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxSpreadAttributeTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxStandardAttributeTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxStandardElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxTextTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.impl.statement.BlockTreeImpl;
import org.sonar.javascript.tree.impl.statement.BreakStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.CaseClauseTreeImpl;
import org.sonar.javascript.tree.impl.statement.CatchBlockTreeImpl;
import org.sonar.javascript.tree.impl.statement.ContinueStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.DebuggerStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.DefaultClauseTreeImpl;
import org.sonar.javascript.tree.impl.statement.DoWhileStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ElseClauseTreeImpl;
import org.sonar.javascript.tree.impl.statement.EmptyStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ExpressionStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.FinallyBlockTreeImpl;
import org.sonar.javascript.tree.impl.statement.ForObjectStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ForStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.IfStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.LabelledStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ReturnStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.SwitchStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ThrowStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.TryStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.statement.VariableStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.WhileStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.WithStatementTreeImpl;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ArrayBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.declaration.ClassTree;
import org.sonar.plugins.javascript.api.tree.declaration.DeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.DecoratorTree;
import org.sonar.plugins.javascript.api.tree.declaration.DefaultExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ExportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.ExportDefaultBinding;
import org.sonar.plugins.javascript.api.tree.declaration.ExportDefaultBindingWithExportList;
import org.sonar.plugins.javascript.api.tree.declaration.ExportDefaultBindingWithNameSpaceExport;
import org.sonar.plugins.javascript.api.tree.declaration.ExtendsClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.FieldDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FromClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportModuleDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NameSpaceExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NamedExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierListTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ArgumentListTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayAssignmentPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentPatternRestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ComputedPropertyNameTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.InitializedAssignmentPatternElementTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewTargetTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectAssignmentPatternPairElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectAssignmentPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.SpreadElementTree;
import org.sonar.plugins.javascript.api.tree.expression.SuperTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxAttributeTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxAttributeValueTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxChildTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxClosingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxElementNameTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxIdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxJavaScriptExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxOpeningElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxSelfClosingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxSpreadAttributeTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxStandardAttributeTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxStandardElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxTextTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DebuggerStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.EmptyStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.FinallyBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;

public class TreeFactory {
    private static final Map<String, Tree.Kind> EXPRESSION_KIND_BY_VALUE = new HashMap<String, Tree.Kind>();
    private static final Map<String, Tree.Kind> PREFIX_KIND_BY_VALUE;

    private static Tree.Kind getBinaryOperator(InternalSyntaxToken token) {
        Tree.Kind kind = EXPRESSION_KIND_BY_VALUE.get(token.text());
        if (kind == null) {
            throw new IllegalArgumentException("Mapping not found for binary operator " + token.text());
        }
        return kind;
    }

    private static Tree.Kind getPrefixOperator(InternalSyntaxToken token) {
        Tree.Kind kind = PREFIX_KIND_BY_VALUE.get(token.text());
        if (kind == null) {
            throw new IllegalArgumentException("Mapping not found for unary operator " + token.text());
        }
        return kind;
    }

    public EmptyStatementTree emptyStatement(InternalSyntaxToken semicolon) {
        return new EmptyStatementTreeImpl(semicolon);
    }

    public DebuggerStatementTree debuggerStatement(InternalSyntaxToken debuggerWord, Tree semicolonToken) {
        return new DebuggerStatementTreeImpl(debuggerWord, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public VariableStatementTree variableStatement(VariableDeclarationTree declaration, Tree semicolonToken) {
        return new VariableStatementTreeImpl(declaration, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    private static VariableDeclarationTree variableDeclaration(InternalSyntaxToken token, SeparatedList<BindingElementTree> variables) {
        Tree.Kind kind;
        if (token.is(JavaScriptKeyword.VAR)) {
            kind = Tree.Kind.VAR_DECLARATION;
        } else if ("let".equals(token.text())) {
            kind = Tree.Kind.LET_DECLARATION;
        } else if (token.is(JavaScriptKeyword.CONST)) {
            kind = Tree.Kind.CONST_DECLARATION;
        } else {
            throw new UnsupportedOperationException("Unsupported token, " + token.text());
        }
        return new VariableDeclarationTreeImpl(kind, token, variables);
    }

    public VariableDeclarationTree variableDeclaration1(InternalSyntaxToken token, SeparatedList<BindingElementTree> variables) {
        return TreeFactory.variableDeclaration(token, variables);
    }

    private static SeparatedList<BindingElementTree> bindingElementList(BindingElementTree element, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> rest) {
        ImmutableList.Builder elements = ImmutableList.builder();
        ImmutableList.Builder commas = ImmutableList.builder();
        elements.add((Object)element);
        if (rest.isPresent()) {
            for (Tuple pair : (List)rest.get()) {
                InternalSyntaxToken commaToken = (InternalSyntaxToken)pair.first();
                commas.add((Object)commaToken);
                elements.add(pair.second());
            }
        }
        return new SeparatedListImpl<BindingElementTree>((List<BindingElementTree>)elements.build(), (List<InternalSyntaxToken>)commas.build());
    }

    public SeparatedList<BindingElementTree> bindingElementList1(BindingElementTree element, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> rest) {
        return TreeFactory.bindingElementList(element, rest);
    }

    public LabelledStatementTree labelledStatement(InternalSyntaxToken labelToken, InternalSyntaxToken colon, StatementTree statement) {
        return new LabelledStatementTreeImpl(labelToken, colon, statement);
    }

    public ContinueStatementTree continueWithLabel(InternalSyntaxToken continueToken, InternalSyntaxToken labelToken, Tree semicolonToken) {
        return new ContinueStatementTreeImpl(continueToken, labelToken, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ContinueStatementTree continueWithoutLabel(InternalSyntaxToken continueToken, Tree semicolonToken) {
        return new ContinueStatementTreeImpl(continueToken, null, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public BreakStatementTree breakWithLabel(InternalSyntaxToken breakToken, InternalSyntaxToken labelToken, Tree semicolonToken) {
        return new BreakStatementTreeImpl(breakToken, labelToken, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public BreakStatementTree breakWithoutLabel(InternalSyntaxToken breakToken, Tree semicolonToken) {
        return new BreakStatementTreeImpl(breakToken, null, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ReturnStatementTree returnWithExpression(InternalSyntaxToken returnToken, ExpressionTree expression, Tree semicolonToken) {
        return new ReturnStatementTreeImpl(returnToken, expression, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ReturnStatementTree returnWithoutExpression(InternalSyntaxToken returnToken, Tree semicolonToken) {
        return new ReturnStatementTreeImpl(returnToken, null, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ThrowStatementTree newThrowStatement(InternalSyntaxToken throwToken, ExpressionTree expression, Tree semicolonToken) {
        return new ThrowStatementTreeImpl(throwToken, expression, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public WithStatementTree newWithStatement(InternalSyntaxToken withToken, InternalSyntaxToken openingParen, ExpressionTree expression, InternalSyntaxToken closingParen, StatementTree statement) {
        return new WithStatementTreeImpl(withToken, openingParen, expression, closingParen, statement);
    }

    public BlockTree newBlock(InternalSyntaxToken openingCurlyBrace, Optional<List<StatementTree>> statements, InternalSyntaxToken closingCurlyBrace) {
        if (statements.isPresent()) {
            return new BlockTreeImpl(openingCurlyBrace, (List)statements.get(), closingCurlyBrace);
        }
        return new BlockTreeImpl(openingCurlyBrace, closingCurlyBrace);
    }

    public FinallyBlockTree finallyBlock(InternalSyntaxToken finallyKeyword, BlockTree finallyBlock) {
        return new FinallyBlockTreeImpl(finallyKeyword, finallyBlock);
    }

    public TryStatementTree tryStatementWithoutCatch(InternalSyntaxToken tryToken, BlockTree block, FinallyBlockTree finallyBlockTree) {
        return new TryStatementTreeImpl(tryToken, block, null, finallyBlockTree);
    }

    public TryStatementTree tryStatementWithCatch(InternalSyntaxToken tryToken, BlockTree block, CatchBlockTree catchBlock, Optional<FinallyBlockTree> finallyBlockTree) {
        return new TryStatementTreeImpl(tryToken, block, catchBlock, (FinallyBlockTree)finallyBlockTree.orNull());
    }

    public CatchBlockTree newCatchBlock(InternalSyntaxToken catchToken, InternalSyntaxToken lparenToken, BindingElementTree catchParameter, InternalSyntaxToken rparenToken, BlockTree block) {
        return new CatchBlockTreeImpl(catchToken, lparenToken, catchParameter, rparenToken, block);
    }

    public SwitchStatementTree switchStatement(InternalSyntaxToken switchToken, InternalSyntaxToken openParenthesis, ExpressionTree expression, InternalSyntaxToken closeParenthesis, InternalSyntaxToken openCurly, Optional<List<SwitchClauseTree>> switchCases, InternalSyntaxToken closeCurly) {
        return new SwitchStatementTreeImpl(switchToken, openParenthesis, expression, closeParenthesis, openCurly, (List)switchCases.or((Object)ImmutableList.of()), closeCurly);
    }

    public List<SwitchClauseTree> switchCases(Optional<List<SwitchClauseTree>> switchCases) {
        return (List)switchCases.or((Object)ImmutableList.of());
    }

    public DefaultClauseTree defaultClause(InternalSyntaxToken defaultToken, InternalSyntaxToken colonToken, Optional<List<StatementTree>> statements) {
        if (statements.isPresent()) {
            return new DefaultClauseTreeImpl(defaultToken, colonToken, (List)statements.get());
        }
        return new DefaultClauseTreeImpl(defaultToken, colonToken);
    }

    public CaseClauseTree caseClause(InternalSyntaxToken caseToken, ExpressionTree expression, InternalSyntaxToken colonToken, Optional<List<StatementTree>> statements) {
        if (statements.isPresent()) {
            return new CaseClauseTreeImpl(caseToken, expression, colonToken, (List)statements.get());
        }
        return new CaseClauseTreeImpl(caseToken, expression, colonToken);
    }

    public ElseClauseTree elseClause(InternalSyntaxToken elseToken, StatementTree statement) {
        return new ElseClauseTreeImpl(elseToken, statement);
    }

    public IfStatementTree ifStatement(InternalSyntaxToken ifToken, InternalSyntaxToken openParenToken, ExpressionTree condition, InternalSyntaxToken closeParenToken, StatementTree statement, Optional<ElseClauseTree> elseClause) {
        if (elseClause.isPresent()) {
            return new IfStatementTreeImpl(ifToken, openParenToken, condition, closeParenToken, statement, (ElseClauseTree)elseClause.get());
        }
        return new IfStatementTreeImpl(ifToken, openParenToken, condition, closeParenToken, statement);
    }

    public WhileStatementTree whileStatement(InternalSyntaxToken whileToken, InternalSyntaxToken openParenthesis, ExpressionTree condition, InternalSyntaxToken closeParenthesis, StatementTree statetment) {
        return new WhileStatementTreeImpl(whileToken, openParenthesis, condition, closeParenthesis, statetment);
    }

    public DoWhileStatementTree doWhileStatement(InternalSyntaxToken doToken, StatementTree statement, InternalSyntaxToken whileToken, InternalSyntaxToken openParenthesis, ExpressionTree condition, InternalSyntaxToken closeParenthesis, Tree semicolonToken) {
        return new DoWhileStatementTreeImpl(doToken, statement, whileToken, openParenthesis, condition, closeParenthesis, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExpressionStatementTree expressionStatement(Tree lookahead, ExpressionTree expression, Tree semicolonToken) {
        return new ExpressionStatementTreeImpl(expression, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    @Nullable
    private static InternalSyntaxToken nullableSemicolonToken(Tree semicolonToken) {
        if (semicolonToken instanceof InternalSyntaxToken) {
            return (InternalSyntaxToken)semicolonToken;
        }
        return null;
    }

    public ForObjectStatementTree forOfStatement(InternalSyntaxToken forToken, Optional<InternalSyntaxToken> awaitToken, InternalSyntaxToken openParenthesis, Tree variableOrExpression, InternalSyntaxToken ofToken, ExpressionTree expression, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        return new ForObjectStatementTreeImpl(forToken, (SyntaxToken)awaitToken.orNull(), openParenthesis, variableOrExpression, ofToken, expression, closeParenthesis, statement);
    }

    public ForObjectStatementTree forInStatement(InternalSyntaxToken forToken, InternalSyntaxToken openParenthesis, Tree variableOrExpression, InternalSyntaxToken inToken, ExpressionTree expression, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        return new ForObjectStatementTreeImpl(forToken, null, openParenthesis, variableOrExpression, inToken, expression, closeParenthesis, statement);
    }

    public ForStatementTree forStatement(InternalSyntaxToken forToken, InternalSyntaxToken openParenthesis, Optional<Tree> init, InternalSyntaxToken firstSemiToken, Optional<ExpressionTree> condition, InternalSyntaxToken secondSemiToken, Optional<ExpressionTree> update, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        return new ForStatementTreeImpl(forToken, openParenthesis, (Tree)init.orNull(), firstSemiToken, (ExpressionTree)condition.orNull(), secondSemiToken, (ExpressionTree)update.orNull(), closeParenthesis, statement);
    }

    public List<Tree> arrayLiteralElements(Optional<List<InternalSyntaxToken>> commaTokens, ExpressionTree element, Optional<List<Tuple<List<InternalSyntaxToken>, ExpressionTree>>> restElements, Optional<List<InternalSyntaxToken>> restCommas) {
        ArrayList elementsAndCommas = Lists.newArrayList();
        if (commaTokens.isPresent()) {
            elementsAndCommas.addAll((Collection)commaTokens.get());
        }
        elementsAndCommas.add(element);
        if (restElements.isPresent()) {
            for (Tuple t : (List)restElements.get()) {
                elementsAndCommas.addAll((Collection)t.first());
                elementsAndCommas.add(t.second());
            }
        }
        if (restCommas.isPresent()) {
            elementsAndCommas.addAll((Collection)restCommas.get());
        }
        return elementsAndCommas;
    }

    public ArrayLiteralTree arrayLiteral(InternalSyntaxToken openBracketToken, Optional<List<Tree>> elements, InternalSyntaxToken closeBracket) {
        return new ArrayLiteralTreeImpl(openBracketToken, (List)elements.or((Object)ImmutableList.of()), closeBracket);
    }

    public FunctionExpressionTree generatorExpression(InternalSyntaxToken functionKeyword, InternalSyntaxToken starOperator, Optional<IdentifierTree> functionName, ParameterListTree parameters, BlockTree body) {
        return FunctionExpressionTreeImpl.createGenerator(functionKeyword, starOperator, (IdentifierTree)functionName.orNull(), parameters, body);
    }

    public LiteralTree nullLiteral(InternalSyntaxToken nullToken) {
        return new LiteralTreeImpl(Tree.Kind.NULL_LITERAL, nullToken);
    }

    public List<Tree> tokenList(List<InternalSyntaxToken> list) {
        return new ArrayList<Tree>(list);
    }

    public LiteralTree booleanLiteral(InternalSyntaxToken trueFalseToken) {
        return new LiteralTreeImpl(Tree.Kind.BOOLEAN_LITERAL, trueFalseToken);
    }

    public LiteralTree numericLiteral(InternalSyntaxToken numericToken) {
        return new LiteralTreeImpl(Tree.Kind.NUMERIC_LITERAL, numericToken);
    }

    public LiteralTree stringLiteral(InternalSyntaxToken stringToken) {
        return new LiteralTreeImpl(Tree.Kind.STRING_LITERAL, stringToken);
    }

    public LiteralTree regexpLiteral(InternalSyntaxToken regexpToken) {
        return new LiteralTreeImpl(Tree.Kind.REGULAR_EXPRESSION_LITERAL, regexpToken);
    }

    public FunctionExpressionTree functionExpression(Optional<InternalSyntaxToken> asyncToken, InternalSyntaxToken functionKeyword, Optional<IdentifierTree> functionName, ParameterListTree parameters, BlockTree body) {
        return FunctionExpressionTreeImpl.create((SyntaxToken)asyncToken.orNull(), functionKeyword, (IdentifierTree)functionName.orNull(), parameters, body);
    }

    public SeparatedList<BindingElementTree> formalParameters(BindingElementTree formalParameter, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> formalParameters) {
        ArrayList parameters = Lists.newArrayList();
        ArrayList commas = Lists.newArrayList();
        parameters.add(formalParameter);
        if (formalParameters.isPresent()) {
            for (Tuple t : (List)formalParameters.get()) {
                commas.add(t.first());
                parameters.add(t.second());
            }
        }
        return new SeparatedListImpl<BindingElementTree>(parameters, commas);
    }

    public ParameterListTree formalParameterClause1(InternalSyntaxToken lParenthesis, SeparatedList<BindingElementTree> parameters, Optional<InternalSyntaxToken> trailingComma, InternalSyntaxToken rParenthesis) {
        if (trailingComma.isPresent()) {
            parameters.getSeparators().add((InternalSyntaxToken)trailingComma.get());
        }
        return new ParameterListTreeImpl(lParenthesis, parameters, rParenthesis);
    }

    public ParameterListTree formalParameterClause2(InternalSyntaxToken lParenthesis, SeparatedList<BindingElementTree> parameters, InternalSyntaxToken comma, RestElementTree restElementTree, InternalSyntaxToken rParenthesis) {
        parameters.getSeparators().add(comma);
        parameters.add(restElementTree);
        return new ParameterListTreeImpl(lParenthesis, parameters, rParenthesis);
    }

    public ParameterListTree formalParameterClause3(InternalSyntaxToken lParenthesis, Optional<RestElementTree> restElementTree, InternalSyntaxToken rParenthesis) {
        SeparatedListImpl<BindingElementTree> parameters = new SeparatedListImpl<BindingElementTree>(Lists.newArrayList(), Collections.emptyList());
        if (restElementTree.isPresent()) {
            parameters.add((BindingElementTree)restElementTree.get());
        }
        return new ParameterListTreeImpl(lParenthesis, parameters, rParenthesis);
    }

    public RestElementTree bindingRestElement(InternalSyntaxToken ellipsis, IdentifierTree identifier) {
        return new RestElementTreeImpl(ellipsis, identifier);
    }

    public ExpressionTree optionalConditionalExpression(ExpressionTree conditionExpression, Optional<ConditionalExpressionTail> conditionalExpressionTail) {
        if (conditionalExpressionTail.isPresent()) {
            ConditionalExpressionTail tail = (ConditionalExpressionTail)conditionalExpressionTail.get();
            return new ConditionalExpressionTreeImpl(conditionExpression, tail.queryToken, tail.trueExpr, tail.colonToken, tail.falseExpr);
        }
        return conditionExpression;
    }

    public ExpressionTree newConditionalOr(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newConditionalAnd(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseOr(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseXor(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseAnd(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newEquality(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newRelational(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newShift(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newAdditive(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newMultiplicative(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newExponentiation(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        List list = (List)operatorAndOperands.get();
        ExpressionTree result = (ExpressionTree)((Tuple)list.get(list.size() - 1)).second;
        for (int i = list.size() - 1; i > 0; --i) {
            result = new BinaryExpressionTreeImpl(Tree.Kind.EXPONENT, (ExpressionTree)((Tuple)list.get(i - 1)).second, (InternalSyntaxToken)((Tuple)list.get(i)).first, result);
        }
        return new BinaryExpressionTreeImpl(Tree.Kind.EXPONENT, expression, (InternalSyntaxToken)((Tuple)list.get(0)).first, result);
    }

    private static ExpressionTree buildBinaryExpression(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        ExpressionTree result = expression;
        for (Tuple t : (List)operatorAndOperands.get()) {
            result = new BinaryExpressionTreeImpl(TreeFactory.getBinaryOperator((InternalSyntaxToken)t.first()), result, (InternalSyntaxToken)t.first(), (ExpressionTree)t.second());
        }
        return result;
    }

    public ExpressionTree prefixExpression(InternalSyntaxToken operator, ExpressionTree expression) {
        return new PrefixExpressionTreeImpl(TreeFactory.getPrefixOperator(operator), operator, expression);
    }

    public ExpressionTree postfixExpression(ExpressionTree expression, Optional<Tuple<InternalSyntaxToken, InternalSyntaxToken>> operatorNoLB) {
        if (!operatorNoLB.isPresent()) {
            return expression;
        }
        Tree.Kind kind = ((InternalSyntaxToken)((Tuple)operatorNoLB.get()).second()).is(JavaScriptPunctuator.INC) ? Tree.Kind.POSTFIX_INCREMENT : Tree.Kind.POSTFIX_DECREMENT;
        return new PostfixExpressionTreeImpl(kind, expression, (InternalSyntaxToken)((Tuple)operatorNoLB.get()).second());
    }

    public IdentifierTree identifierReference(InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.IDENTIFIER_REFERENCE, identifier);
    }

    public IdentifierTree bindingIdentifier(InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.BINDING_IDENTIFIER, identifier);
    }

    public ArrowFunctionTree arrowFunction(Optional<InternalSyntaxToken> asyncToken, Tree parameters, Tree spacingNoLB, InternalSyntaxToken doubleArrow, Tree body) {
        return new ArrowFunctionTreeImpl((SyntaxToken)asyncToken.orNull(), parameters, doubleArrow, body);
    }

    public IdentifierTree identifierName(InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.PROPERTY_IDENTIFIER, identifier);
    }

    public SuperTree superExpression(InternalSyntaxToken superToken) {
        return new SuperTreeImpl(superToken);
    }

    public NewTargetTree newTarget(SyntaxToken newKeyword, SyntaxToken dot, SyntaxToken target) {
        return new NewTargetTreeImpl(newKeyword, dot, target);
    }

    public ExpressionTree memberExpression(ExpressionTree object, Optional<List<ExpressionTail>> tails) {
        return TreeFactory.tailedExpression(object, tails);
    }

    public SeparatedList<ExpressionTree> argumentList(ExpressionTree argument, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> restArguments, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList arguments = Lists.newArrayList();
        ArrayList commas = Lists.newArrayList();
        arguments.add(argument);
        if (restArguments.isPresent()) {
            for (Tuple t : (List)restArguments.get()) {
                commas.add(t.first());
                arguments.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new SeparatedListImpl<ExpressionTree>(arguments, commas);
    }

    public ArgumentListTree argumentClause(InternalSyntaxToken openParenToken, Optional<SeparatedList<ExpressionTree>> arguments, InternalSyntaxToken closeParenToken) {
        return new ArgumentListTreeImpl(openParenToken, arguments.isPresent() ? (SeparatedList)arguments.get() : new SeparatedListImpl(Collections.emptyList(), Collections.emptyList()), closeParenToken);
    }

    public CallExpressionTree simpleCallExpression(ExpressionTree expression, ArgumentListTree arguments) {
        return new CallExpressionTreeImpl(expression, arguments);
    }

    public ExpressionTree callExpression(CallExpressionTree callExpression, Optional<List<ExpressionTail>> tails) {
        return TreeFactory.tailedExpression(callExpression, tails);
    }

    private static ExpressionTree tailedExpression(ExpressionTree mainExpression, Optional<List<ExpressionTail>> tails) {
        if (!tails.isPresent()) {
            return mainExpression;
        }
        ExpressionTree result = mainExpression;
        for (ExpressionTail tail : (List)tails.get()) {
            if (tail instanceof BracketAccessTail) {
                BracketAccessTail bracketAccessTail = (BracketAccessTail)tail;
                result = new BracketMemberExpressionTreeImpl(result, bracketAccessTail.lBracket, bracketAccessTail.expressionTree, bracketAccessTail.rBracket);
                continue;
            }
            if (tail instanceof DotAccessTail) {
                DotAccessTail dotAccessTail = (DotAccessTail)tail;
                result = new DotMemberExpressionTreeImpl(result, dotAccessTail.dot, dotAccessTail.identifierTree);
                continue;
            }
            if (tail instanceof TemplateLiteralTail) {
                result = new TaggedTemplateTreeImpl(result, ((TemplateLiteralTail)tail).templateLiteralTree);
                continue;
            }
            result = new CallExpressionTreeImpl(result, ((ArgumentsTail)tail).argumentClause);
        }
        return result;
    }

    public ParenthesisedExpressionTree parenthesisedExpression(InternalSyntaxToken openParenToken, ExpressionTree expression, InternalSyntaxToken closeParenToken) {
        return new ParenthesisedExpressionTreeImpl(openParenToken, expression, closeParenToken);
    }

    public ClassTree classExpression(Optional<List<DecoratorTree>> decorators, InternalSyntaxToken classToken, Optional<IdentifierTree> name, Optional<ExtendsClauseTree> extendsClause, InternalSyntaxToken openCurlyBraceToken, Optional<List<Tree>> members, InternalSyntaxToken closeCurlyBraceToken) {
        ArrayList elements = Lists.newArrayList();
        if (members.isPresent()) {
            for (Tree member : (List)members.get()) {
                elements.add(member);
            }
        }
        return ClassTreeImpl.newClassExpression(TreeFactory.optionalList(decorators), classToken, (IdentifierTree)name.orNull(), (ExtendsClauseTree)extendsClause.orNull(), openCurlyBraceToken, elements, closeCurlyBraceToken);
    }

    public ComputedPropertyNameTree computedPropertyName(InternalSyntaxToken openBracketToken, ExpressionTree expression, InternalSyntaxToken closeBracketToken) {
        return new ComputedPropertyNameTreeImpl(openBracketToken, expression, closeBracketToken);
    }

    public PairPropertyTree pairProperty(Tree name, InternalSyntaxToken colonToken, ExpressionTree value) {
        return new PairPropertyTreeImpl(name, colonToken, value);
    }

    public SpreadElementTree spreadElement(InternalSyntaxToken ellipsis, ExpressionTree expression) {
        return new SpreadElementTreeImpl(ellipsis, expression);
    }

    public SeparatedList<Tree> properties(Tree property, Optional<List<Tuple<InternalSyntaxToken, Tree>>> restProperties, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList commas = Lists.newArrayList();
        ArrayList properties = Lists.newArrayList();
        properties.add(property);
        if (restProperties.isPresent()) {
            for (Tuple t : (List)restProperties.get()) {
                commas.add(t.first());
                properties.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new SeparatedListImpl<Tree>(properties, commas);
    }

    public ObjectLiteralTree objectLiteral(InternalSyntaxToken openCurlyToken, Optional<SeparatedList<Tree>> properties, InternalSyntaxToken closeCurlyToken) {
        return new ObjectLiteralTreeImpl(openCurlyToken, (SeparatedList)properties.or(new SeparatedListImpl(ImmutableList.of(), (List<InternalSyntaxToken>)ImmutableList.of())), closeCurlyToken);
    }

    public NewExpressionTree newExpressionWithArgument(InternalSyntaxToken newToken, ExpressionTree expression, ArgumentListTree arguments) {
        return new NewExpressionTreeImpl(expression.is(Tree.Kind.SUPER) ? Tree.Kind.NEW_SUPER : Tree.Kind.NEW_EXPRESSION, newToken, expression, arguments);
    }

    public ExpressionTree newExpression(InternalSyntaxToken newToken, ExpressionTree expression) {
        return new NewExpressionTreeImpl(expression.is(Tree.Kind.SUPER) ? Tree.Kind.NEW_SUPER : Tree.Kind.NEW_EXPRESSION, newToken, expression);
    }

    public TemplateLiteralTree noSubstitutionTemplate(InternalSyntaxToken openBacktickToken, Optional<TemplateCharactersTree> templateCharacters, InternalSyntaxToken closeBacktickToken) {
        return new TemplateLiteralTreeImpl(openBacktickToken, templateCharacters.isPresent() ? Collections.singletonList(templateCharacters.get()) : Collections.emptyList(), closeBacktickToken);
    }

    public TemplateExpressionTree templateExpression(InternalSyntaxToken dollar, InternalSyntaxToken openCurlyBrace, ExpressionTree expression, InternalSyntaxToken closeCurlyBrace) {
        return new TemplateExpressionTreeImpl(dollar, openCurlyBrace, expression, closeCurlyBrace);
    }

    public TemplateLiteralTree substitutionTemplate(InternalSyntaxToken openBacktick, Optional<TemplateCharactersTree> firstCharacters, Optional<List<Tuple<TemplateExpressionTree, Optional<TemplateCharactersTree>>>> list, InternalSyntaxToken closeBacktick) {
        ArrayList<Tree> elements = new ArrayList<Tree>();
        if (firstCharacters.isPresent()) {
            elements.add((Tree)firstCharacters.get());
        }
        if (list.isPresent()) {
            for (Tuple tuple : (List)list.get()) {
                elements.add((Tree)tuple.first());
                if (!((Optional)tuple.second()).isPresent()) continue;
                elements.add((Tree)((Optional)tuple.second()).get());
            }
        }
        return new TemplateLiteralTreeImpl(openBacktick, elements, closeBacktick);
    }

    public TemplateCharactersTree templateCharacters(List<InternalSyntaxToken> characters) {
        ArrayList<InternalSyntaxToken> characterTokens = new ArrayList<InternalSyntaxToken>();
        for (InternalSyntaxToken character : characters) {
            characterTokens.add(character);
        }
        return new TemplateCharactersTreeImpl(characterTokens);
    }

    public IdentifierTree thisExpression(InternalSyntaxToken thisKeyword) {
        return new IdentifierTreeImpl(Tree.Kind.THIS, thisKeyword);
    }

    public InternalSyntaxToken labelToken(Tree spacing, InternalSyntaxToken labelToken) {
        return labelToken;
    }

    public ExpressionTree assignmentExpression(ExpressionTree variable, InternalSyntaxToken operator, ExpressionTree expression) {
        return TreeFactory.commonAssignmentExpression(variable, operator, expression);
    }

    public ExpressionTree assignmentWithArrayDestructuring(ExpressionTree variable, InternalSyntaxToken operator, ExpressionTree expression) {
        return TreeFactory.commonAssignmentExpression(variable, operator, expression);
    }

    private static ExpressionTree commonAssignmentExpression(ExpressionTree variable, InternalSyntaxToken operator, ExpressionTree expression) {
        return new AssignmentExpressionTreeImpl(EXPRESSION_KIND_BY_VALUE.get(operator.text()), variable, operator, expression);
    }

    public ExpressionTree expression(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree expressionNoLineBreak(Tree spacingNoLineBreak, ExpressionTree expression) {
        return expression;
    }

    public FromClauseTree fromClause(InternalSyntaxToken fromToken, LiteralTree module) {
        return new FromClauseTreeImpl(fromToken, module);
    }

    public DefaultExportDeclarationTree defaultExportDeclaration(Optional<List<DecoratorTree>> decorators, InternalSyntaxToken exportToken, InternalSyntaxToken defaultToken, Object declaration) {
        Tree deducedDeclaration;
        InternalSyntaxToken eos = null;
        if (declaration instanceof Tuple) {
            deducedDeclaration = (Tree)((Tuple)declaration).first();
            eos = TreeFactory.nullableSemicolonToken((Tree)((Tuple)declaration).second());
        } else {
            deducedDeclaration = (Tree)declaration;
        }
        return new DefaultExportDeclarationTreeImpl((List)decorators.or((Object)ImmutableList.of()), exportToken, defaultToken, deducedDeclaration, eos);
    }

    public NamedExportDeclarationTree namedExportDeclaration(Optional<List<DecoratorTree>> decorators, InternalSyntaxToken exportToken, Tree object) {
        return new NamedExportDeclarationTreeImpl((List)decorators.or((Object)ImmutableList.of()), exportToken, object);
    }

    public SpecifierTree exportSpecifier(IdentifierTree name1, InternalSyntaxToken asToken, IdentifierTree name2) {
        return new SpecifierTreeImpl(Tree.Kind.EXPORT_SPECIFIER, name1, asToken, name2);
    }

    public SpecifierTree exportSpecifier(IdentifierTree name) {
        return new SpecifierTreeImpl(Tree.Kind.EXPORT_SPECIFIER, name);
    }

    public SeparatedList<SpecifierTree> exportListBody(SpecifierTree specifier, Optional<List<Tuple<InternalSyntaxToken, SpecifierTree>>> restSpecifier, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList commas = Lists.newArrayList();
        ArrayList specifiers = Lists.newArrayList();
        specifiers.add(specifier);
        if (restSpecifier.isPresent()) {
            for (Tuple t : (List)restSpecifier.get()) {
                commas.add(t.first());
                specifiers.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new SeparatedListImpl<SpecifierTree>(specifiers, commas);
    }

    public SpecifierListTree exportList(InternalSyntaxToken openCurlyBraceToken, Optional<SeparatedList<SpecifierTree>> specifierList, InternalSyntaxToken closeCurlyBraceToken) {
        return new SpecifierListTreeImpl(Tree.Kind.EXPORT_LIST, openCurlyBraceToken, (SeparatedList)specifierList.or(new SeparatedListImpl(ImmutableList.of(), (List<InternalSyntaxToken>)ImmutableList.of())), closeCurlyBraceToken);
    }

    public NameSpaceExportDeclarationTree namespaceExportDeclaration(InternalSyntaxToken exportToken, InternalSyntaxToken starToken, Optional<Tuple<InternalSyntaxToken, IdentifierTree>> nameSpaceExport, FromClauseTree fromClause, Tree semicolonToken) {
        InternalSyntaxToken asToken = null;
        IdentifierTree synonymIdentifier = null;
        if (nameSpaceExport.isPresent()) {
            asToken = (InternalSyntaxToken)((Tuple)nameSpaceExport.get()).first;
            synonymIdentifier = (IdentifierTree)((Tuple)nameSpaceExport.get()).second;
        }
        return new NameSpaceExportDeclarationTreeImpl(exportToken, starToken, asToken, synonymIdentifier, fromClause, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExportClauseTree exportClause(SpecifierListTree exportList, Optional<FromClauseTree> fromClause, Tree semicolonToken) {
        if (fromClause.isPresent()) {
            return new ExportClauseTreeImpl(exportList, (FromClauseTree)fromClause.get(), TreeFactory.nullableSemicolonToken(semicolonToken));
        }
        return new ExportClauseTreeImpl(exportList, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExportDefaultBinding exportDefaultBinding(IdentifierTree identifierTree, FromClauseTree fromClauseTree, Tree semicolonToken) {
        return new ExportDefaultBindingImpl(identifierTree, fromClauseTree, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExportDefaultBindingWithNameSpaceExport exportDefaultBindingWithNameSpaceExport(IdentifierTree identifierTree, InternalSyntaxToken commaToken, InternalSyntaxToken starToken, InternalSyntaxToken asToken, IdentifierTree synonymIdentifier, FromClauseTree fromClause, Tree semicolon) {
        return new ExportDefaultBindingWithNameSpaceExportImpl(identifierTree, commaToken, starToken, asToken, synonymIdentifier, fromClause, TreeFactory.nullableSemicolonToken(semicolon));
    }

    public ExportDefaultBindingWithExportList exportDefaultBindingWithExportList(IdentifierTree identifierTree, InternalSyntaxToken commaToken, SpecifierListTree specifierListTree, FromClauseTree fromClauseTree, Tree semicolon) {
        return new ExportDefaultBindingWithExportListImpl(identifierTree, commaToken, specifierListTree, fromClauseTree, TreeFactory.nullableSemicolonToken(semicolon));
    }

    public ImportModuleDeclarationTree importModuleDeclaration(InternalSyntaxToken importToken, LiteralTree moduleName, Tree semicolonToken) {
        return new ImportModuleDeclarationTreeImpl(importToken, moduleName, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public SpecifierTree newImportSpecifier(IdentifierTree name, InternalSyntaxToken asToken, IdentifierTree identifier) {
        return new SpecifierTreeImpl(Tree.Kind.IMPORT_SPECIFIER, name, asToken, identifier);
    }

    public SpecifierTree importSpecifier(IdentifierTree name) {
        return new SpecifierTreeImpl(Tree.Kind.IMPORT_SPECIFIER, name);
    }

    public SeparatedList<SpecifierTree> newImportSpecifierList(SpecifierTree specifier, Optional<List<Tuple<InternalSyntaxToken, SpecifierTree>>> restSpecifier, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList commas = Lists.newArrayList();
        ArrayList specifiers = Lists.newArrayList();
        specifiers.add(specifier);
        if (restSpecifier.isPresent()) {
            for (Tuple t : (List)restSpecifier.get()) {
                commas.add(t.first());
                specifiers.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new SeparatedListImpl<SpecifierTree>(specifiers, commas);
    }

    public SpecifierListTree importList(InternalSyntaxToken openCurlyBraceToken, Optional<SeparatedList<SpecifierTree>> specifierList, InternalSyntaxToken closeCurlyBraceToken) {
        return new SpecifierListTreeImpl(Tree.Kind.IMPORT_LIST, openCurlyBraceToken, (SeparatedList)specifierList.or(new SeparatedListImpl(ImmutableList.of(), (List<InternalSyntaxToken>)ImmutableList.of())), closeCurlyBraceToken);
    }

    public SpecifierTree nameSpaceImport(InternalSyntaxToken starToken, InternalSyntaxToken asToken, IdentifierTree localName) {
        return new NameSpaceSpecifierTreeImpl(starToken, asToken, localName);
    }

    public ImportClauseTree defaultImport(IdentifierTree identifierTree, Optional<Tuple<InternalSyntaxToken, DeclarationTree>> namedImport) {
        if (namedImport.isPresent()) {
            return new ImportClauseTreeImpl(identifierTree, (InternalSyntaxToken)((Tuple)namedImport.get()).first(), (DeclarationTree)((Tuple)namedImport.get()).second());
        }
        return new ImportClauseTreeImpl(identifierTree);
    }

    public ImportClauseTree importClause(DeclarationTree importTree) {
        if (importTree instanceof ImportClauseTree) {
            return (ImportClauseTreeImpl)importTree;
        }
        return new ImportClauseTreeImpl(importTree);
    }

    public ImportDeclarationTree importDeclaration(InternalSyntaxToken importToken, ImportClauseTree importClause, FromClauseTree fromClause, Tree semicolonToken) {
        return new ImportDeclarationTreeImpl(importToken, importClause, fromClause, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ModuleTree module(List<Tree> items) {
        return new ModuleTreeImpl(items);
    }

    public ClassTree classDeclaration(Optional<List<DecoratorTree>> decorators, InternalSyntaxToken classToken, IdentifierTree name, Optional<ExtendsClauseTree> extendsClause, InternalSyntaxToken openCurlyBraceToken, Optional<List<Tree>> members, InternalSyntaxToken closeCurlyBraceToken) {
        ArrayList elements = Lists.newArrayList();
        if (members.isPresent()) {
            for (Tree member : (List)members.get()) {
                elements.add(member);
            }
        }
        return ClassTreeImpl.newClassDeclaration(TreeFactory.optionalList(decorators), classToken, name, (ExtendsClauseTree)extendsClause.orNull(), openCurlyBraceToken, elements, closeCurlyBraceToken);
    }

    public MethodDeclarationTree generatorMethod(Optional<List<DecoratorTree>> decorators, Optional<InternalSyntaxToken> staticToken, InternalSyntaxToken starToken, Tree name, ParameterListTree parameters, BlockTree body) {
        return MethodDeclarationTreeImpl.generator(TreeFactory.optionalList(decorators), (InternalSyntaxToken)staticToken.orNull(), starToken, name, parameters, body);
    }

    public MethodDeclarationTree method(Optional<List<DecoratorTree>> decorators, Optional<InternalSyntaxToken> staticToken, Optional<InternalSyntaxToken> asyncToken, Tree name, ParameterListTree parameters, BlockTree body) {
        return MethodDeclarationTreeImpl.method(TreeFactory.optionalList(decorators), (InternalSyntaxToken)staticToken.orNull(), (InternalSyntaxToken)asyncToken.orNull(), name, parameters, body);
    }

    public AccessorMethodDeclarationTree accessor(Optional<List<DecoratorTree>> decorators, Optional<InternalSyntaxToken> staticToken, InternalSyntaxToken accessorToken, Tree name, ParameterListTree parameters, BlockTree body) {
        return new AccessorMethodDeclarationTreeImpl(TreeFactory.optionalList(decorators), (InternalSyntaxToken)staticToken.orNull(), accessorToken, name, parameters, body);
    }

    public FunctionDeclarationTree functionAndGeneratorDeclaration(Optional<InternalSyntaxToken> asyncToken, InternalSyntaxToken functionToken, Optional<InternalSyntaxToken> starToken, IdentifierTree name, ParameterListTree parameters, BlockTree body) {
        return starToken.isPresent() ? FunctionDeclarationTreeImpl.createGenerator(functionToken, (InternalSyntaxToken)starToken.get(), name, parameters, body) : FunctionDeclarationTreeImpl.create((SyntaxToken)asyncToken.orNull(), functionToken, name, parameters, body);
    }

    public InitializedBindingElementTree initializedBindingElement(BindingElementTree left, InternalSyntaxToken equalToken, ExpressionTree expression) {
        return new InitializedBindingElementTreeImpl(left, equalToken, expression);
    }

    public BindingPropertyTree bindingProperty(Tree propertyName, InternalSyntaxToken colonToken, BindingElementTree bindingElement) {
        return new BindingPropertyTreeImpl(propertyName, colonToken, bindingElement);
    }

    public RestElementTree restObjectBindingElement(InternalSyntaxToken ellipsis, BindingElementTree bindingElement) {
        return new RestElementTreeImpl(ellipsis, bindingElement);
    }

    public SeparatedList<BindingElementTree> bindingPropertyList(BindingElementTree bindingProperty, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> restProperties) {
        ArrayList properties = Lists.newArrayList();
        ArrayList commas = Lists.newArrayList();
        properties.add(bindingProperty);
        if (restProperties.isPresent()) {
            for (Tuple tuple : (List)restProperties.get()) {
                commas.add(tuple.first());
                properties.add(tuple.second());
            }
        }
        return new SeparatedListImpl<BindingElementTree>(properties, commas);
    }

    public ObjectBindingPatternTree objectBindingPattern(InternalSyntaxToken lCurlyBrace, Optional<SeparatedList<BindingElementTree>> list, Optional<Tuple<InternalSyntaxToken, Optional<RestElementTree>>> commaAndRest, InternalSyntaxToken rCurlyBrace) {
        SeparatedListImpl<BindingElementTree> elements = list.isPresent() ? (SeparatedListImpl<BindingElementTree>)list.get() : new SeparatedListImpl<BindingElementTree>(new ArrayList(), new ArrayList<InternalSyntaxToken>());
        if (commaAndRest.isPresent()) {
            elements.getSeparators().add((InternalSyntaxToken)((Tuple)commaAndRest.get()).first);
            if (((Optional)((Tuple)commaAndRest.get()).second).isPresent()) {
                elements.add(((Optional)((Tuple)commaAndRest.get()).second).get());
            }
        }
        return new ObjectBindingPatternTreeImpl(lCurlyBrace, elements, rCurlyBrace);
    }

    public ObjectBindingPatternTree objectBindingPattern2(InternalSyntaxToken lCurlyBrace, RestElementTree rest, InternalSyntaxToken rCurlyBrace) {
        return new ObjectBindingPatternTreeImpl(lCurlyBrace, new SeparatedListImpl<BindingElementTree>((List<BindingElementTree>)ImmutableList.of((Object)rest), (List<InternalSyntaxToken>)ImmutableList.of()), rCurlyBrace);
    }

    public ArrayBindingPatternTree arrayBindingPattern(InternalSyntaxToken openBracketToken, Optional<BindingElementTree> firstElement, Optional<List<Tuple<InternalSyntaxToken, Optional<BindingElementTree>>>> optionalElements, Optional<BindingElementTree> restElement, InternalSyntaxToken closeBracketToken) {
        return new ArrayBindingPatternTreeImpl(openBracketToken, TreeFactory.getSeparatedListOfOptional(firstElement, optionalElements, restElement), closeBracketToken);
    }

    public ArrayAssignmentPatternTree arrayAssignmentPattern(InternalSyntaxToken openBracketToken, Optional<Tree> firstElement, Optional<List<Tuple<InternalSyntaxToken, Optional<Tree>>>> optionalElements, Optional<Tree> restElement, InternalSyntaxToken closeBracketToken) {
        return new ArrayAssignmentPatternTreeImpl(openBracketToken, TreeFactory.getSeparatedListOfOptional(firstElement, optionalElements, restElement), closeBracketToken);
    }

    private static <T extends Tree> SeparatedList<java.util.Optional<T>> getSeparatedListOfOptional(Optional<T> firstElement, Optional<List<Tuple<InternalSyntaxToken, Optional<T>>>> optionalElements, Optional<T> restElement) {
        ImmutableList.Builder elements = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        boolean skipComma = false;
        if (firstElement.isPresent()) {
            elements.add(TreeFactory.convertOptional(firstElement));
            skipComma = true;
        }
        if (optionalElements.isPresent()) {
            List list = (List)optionalElements.get();
            for (Tuple pair : list) {
                if (!skipComma) {
                    elements.add(java.util.Optional.empty());
                }
                InternalSyntaxToken commaToken = (InternalSyntaxToken)pair.first();
                separators.add((Object)commaToken);
                if (((Optional)pair.second()).isPresent()) {
                    elements.add(TreeFactory.convertOptional((Optional)pair.second()));
                    skipComma = true;
                    continue;
                }
                skipComma = false;
            }
        }
        if (restElement.isPresent()) {
            elements.add(TreeFactory.convertOptional(restElement));
        }
        return new SeparatedListImpl<java.util.Optional<T>>(elements.build(), (List<InternalSyntaxToken>)separators.build());
    }

    private static <T extends Tree> java.util.Optional<T> convertOptional(Optional<T> optional) {
        if (optional.isPresent()) {
            return java.util.Optional.of(optional.get());
        }
        return java.util.Optional.empty();
    }

    public ExpressionTree assignmentNoCurly(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public ExpressionTree skipLookahead(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public ExpressionTree skipLookaheadAfter(ExpressionTree expression, Tree lookahead) {
        return expression;
    }

    public ScriptTree script(Optional<InternalSyntaxToken> shebangToken, Optional<ModuleTree> items, Tree spacing, InternalSyntaxToken eof) {
        return new ScriptTreeImpl(shebangToken.isPresent() ? (InternalSyntaxToken)shebangToken.get() : null, items.isPresent() ? (ModuleTree)items.get() : null, eof);
    }

    public ExpressionTree defaultExportExpression(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public JsxSelfClosingElementTree jsxSelfClosingElement(InternalSyntaxToken ltToken, JsxElementNameTree jsxElementNameTree, Optional<List<JsxAttributeTree>> attributes, InternalSyntaxToken divToken, InternalSyntaxToken gtToken) {
        return new JsxSelfClosingElementTreeImpl(ltToken, jsxElementNameTree, TreeFactory.optionalList(attributes), divToken, gtToken);
    }

    public JsxStandardElementTree jsxStandardElement(JsxOpeningElementTree jsxOpeningElementTree, Optional<List<JsxChildTree>> children, JsxClosingElementTree jsxClosingElementTree) {
        return new JsxStandardElementTreeImpl(jsxOpeningElementTree, TreeFactory.optionalList(children), jsxClosingElementTree);
    }

    public JsxOpeningElementTree jsxOpeningElement(InternalSyntaxToken ltToken, JsxElementNameTree jsxElementNameTree, Optional<List<JsxAttributeTree>> attributes, InternalSyntaxToken gtToken) {
        return new JsxOpeningElementTreeImpl(ltToken, jsxElementNameTree, TreeFactory.optionalList(attributes), gtToken);
    }

    public JsxClosingElementTree jsxClosingElement(InternalSyntaxToken ltToken, InternalSyntaxToken divToken, JsxElementNameTree jsxElementNameTree, InternalSyntaxToken gtToken) {
        return new JsxClosingElementTreeImpl(ltToken, divToken, jsxElementNameTree, gtToken);
    }

    public JsxJavaScriptExpressionTree jsxJavaScriptExpression(InternalSyntaxToken lCurlyBraceToken, Optional<ExpressionTree> expression, InternalSyntaxToken rCurlyBraceToken) {
        return new JsxJavaScriptExpressionTreeImpl(lCurlyBraceToken, (ExpressionTree)expression.orNull(), rCurlyBraceToken);
    }

    public JsxJavaScriptExpressionTree jsxJavaScriptExpression(InternalSyntaxToken lCurlyBraceToken, ExpressionTree expression, InternalSyntaxToken rCurlyBraceToken) {
        return new JsxJavaScriptExpressionTreeImpl(lCurlyBraceToken, expression, rCurlyBraceToken);
    }

    public JsxStandardAttributeTree jsxStandardAttribute(JsxIdentifierTree name, InternalSyntaxToken equalToken, JsxAttributeValueTree jsxAttributeValueTree) {
        return new JsxStandardAttributeTreeImpl(name, equalToken, jsxAttributeValueTree);
    }

    public JsxSpreadAttributeTree jsxSpreadAttribute(InternalSyntaxToken lCurlyBraceToken, InternalSyntaxToken ellipsisToken, ExpressionTree expressionTree, InternalSyntaxToken rCurlyBraceToken) {
        return new JsxSpreadAttributeTreeImpl(lCurlyBraceToken, ellipsisToken, expressionTree, rCurlyBraceToken);
    }

    public JsxTextTree jsxTextTree(InternalSyntaxToken token) {
        return new JsxTextTreeImpl(token);
    }

    public JsxIdentifierTree jsxIdentifier(InternalSyntaxToken identifierToken) {
        return new JsxIdentifierTreeImpl(identifierToken);
    }

    public JsxIdentifierTree jsxHtmlTag(InternalSyntaxToken htmlTagToken) {
        return new JsxIdentifierTreeImpl(htmlTagToken);
    }

    public ExpressionTree jsxMemberExpression(IdentifierTree identifierTree, List<Tuple<InternalSyntaxToken, IdentifierTree>> rest) {
        ExpressionTree currentObject = identifierTree;
        for (Tuple<InternalSyntaxToken, IdentifierTree> tuple : rest) {
            currentObject = new DotMemberExpressionTreeImpl(currentObject, (SyntaxToken)((Tuple)tuple).first, (IdentifierTree)((Tuple)tuple).second);
        }
        return currentObject;
    }

    public FieldDeclarationTree fieldDeclaration(Optional<List<DecoratorTree>> decorators, Optional<InternalSyntaxToken> staticToken, Tree propertyName, Optional<Tuple<InternalSyntaxToken, ExpressionTree>> initializer, Tree semicolonToken) {
        if (initializer.isPresent()) {
            return new FieldDeclarationTreeImpl(TreeFactory.optionalList(decorators), (SyntaxToken)staticToken.orNull(), propertyName, (SyntaxToken)((Tuple)initializer.get()).first, (ExpressionTree)((Tuple)initializer.get()).second, TreeFactory.nullableSemicolonToken(semicolonToken));
        }
        return new FieldDeclarationTreeImpl(TreeFactory.optionalList(decorators), (SyntaxToken)staticToken.orNull(), propertyName, null, null, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public DecoratorTree decorator(InternalSyntaxToken atToken, IdentifierTree name, Optional<List<Tuple<InternalSyntaxToken, IdentifierTree>>> rest, Optional<ArgumentListTree> arguments) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ImmutableList.Builder dotsListBuilder = ImmutableList.builder();
        listBuilder.add((Object)name);
        for (Tuple tuple : (List)rest.or(new ArrayList())) {
            dotsListBuilder.add(tuple.first);
            listBuilder.add(tuple.second);
        }
        SeparatedListImpl<IdentifierTree> body = new SeparatedListImpl<IdentifierTree>((List<IdentifierTree>)listBuilder.build(), (List<InternalSyntaxToken>)dotsListBuilder.build());
        return new DecoratorTreeImpl(atToken, body, (ArgumentListTree)arguments.orNull());
    }

    public AssignmentPatternRestElementTree assignmentPatternRestElement(InternalSyntaxToken ellipsisToken, ExpressionTree rest) {
        return new AssignmentPatternRestElementTreeImpl(ellipsisToken, rest);
    }

    public InitializedAssignmentPatternElementTree initializedAssignmentPatternElement(ExpressionTree expression, InternalSyntaxToken equal, ExpressionTree initValue) {
        return new InitializedAssignmentPatternElementTreeImpl(expression, equal, initValue);
    }

    public ObjectAssignmentPatternPairElementTree objectAssignmentPatternPairElement(IdentifierTree identifierName, InternalSyntaxToken colonToken, Tree rhs) {
        return new ObjectAssignmentPatternPairElementTreeImpl(identifierName, colonToken, rhs);
    }

    public ObjectAssignmentPatternTree emptyObjectAssignmentPattern(InternalSyntaxToken lBrace, InternalSyntaxToken rBrace) {
        return new ObjectAssignmentPatternTreeImpl(lBrace, new SeparatedListImpl<Tree>(new ArrayList(), new ArrayList<InternalSyntaxToken>()), rBrace);
    }

    public ObjectAssignmentPatternTree objectAssignmentPattern(InternalSyntaxToken lBrace, Tree firstProperty, Optional<List<Tuple<InternalSyntaxToken, Tree>>> properties, Optional<InternalSyntaxToken> comma, InternalSyntaxToken rBrace) {
        ArrayList<Object> propertyList = new ArrayList<Object>();
        ArrayList<InternalSyntaxToken> separators = new ArrayList<InternalSyntaxToken>();
        propertyList.add(firstProperty);
        for (Tuple tuple : (List)properties.or(new ArrayList())) {
            separators.add((InternalSyntaxToken)tuple.first);
            propertyList.add(tuple.second);
        }
        if (comma.isPresent()) {
            separators.add((InternalSyntaxToken)comma.get());
        }
        return new ObjectAssignmentPatternTreeImpl(lBrace, new SeparatedListImpl<Tree>(propertyList, separators), rBrace);
    }

    public YieldExpressionTree yieldExpression(InternalSyntaxToken yieldToken, Optional<Tuple<InternalSyntaxToken, Tuple<Optional<InternalSyntaxToken>, ExpressionTree>>> optional) {
        InternalSyntaxToken starToken = null;
        ExpressionTree expressionTree = null;
        if (optional.isPresent()) {
            starToken = (InternalSyntaxToken)((Optional)((Tuple)((Tuple)optional.get()).second).first).orNull();
            expressionTree = (ExpressionTree)((Tuple)((Tuple)optional.get()).second).second;
        }
        return new YieldExpressionTreeImpl(yieldToken, starToken, expressionTree);
    }

    public ConditionalExpressionTail conditionalExpressionTail(InternalSyntaxToken queryToken, ExpressionTree trueExpr, InternalSyntaxToken colonToken, ExpressionTree falseExpr) {
        return new ConditionalExpressionTail(queryToken, trueExpr, colonToken, falseExpr);
    }

    public BracketAccessTail newBracketAccess(InternalSyntaxToken lBracket, ExpressionTree expression, InternalSyntaxToken rBracket) {
        return new BracketAccessTail(lBracket, expression, rBracket);
    }

    public ArgumentsTail argumentClauseTail(ArgumentListTree argumentListTree) {
        return new ArgumentsTail(argumentListTree);
    }

    public DotAccessTail dotAccess(InternalSyntaxToken dotToken, IdentifierTree identifierTree) {
        return new DotAccessTail(dotToken, identifierTree);
    }

    public TemplateLiteralTail templateLiteralTailForMember(TemplateLiteralTree templateLiteralTree) {
        return new TemplateLiteralTail(templateLiteralTree);
    }

    public TemplateLiteralTail templateLiteralTailForCall(TemplateLiteralTree templateLiteralTree) {
        return new TemplateLiteralTail(templateLiteralTree);
    }

    public ExtendsClauseTree extendsClause(InternalSyntaxToken extendsToken, ExpressionTree superClass) {
        return new ExtendsClauseTreeImpl(extendsToken, superClass);
    }

    public ScriptTree vueScript(Optional<List<VueElement>> vueElements, Tree noSpacing, InternalSyntaxToken eofToken) {
        if (vueElements.isPresent()) {
            for (VueElement vueElement : (List)vueElements.get()) {
                if (!(vueElement instanceof ScriptVueElement)) continue;
                ScriptVueElement scriptVueElement = (ScriptVueElement)vueElement;
                return new ScriptTreeImpl(scriptVueElement.shebang, scriptVueElement.moduleTree, eofToken);
            }
        }
        return new ScriptTreeImpl(null, null, eofToken);
    }

    public VueElement vueElement(InternalSyntaxToken token) {
        return new VueElement();
    }

    public ScriptVueElement scriptVueElement(InternalSyntaxToken scriptOpenTag, Optional<InternalSyntaxToken> shebangToken, Optional<ModuleTree> items, InternalSyntaxToken scriptCloseTag) {
        return new ScriptVueElement((InternalSyntaxToken)shebangToken.orNull(), (ModuleTree)items.orNull());
    }

    private static <T> List<T> optionalList(Optional<List<T>> list) {
        if (list.isPresent()) {
            return (List)list.get();
        }
        return Collections.emptyList();
    }

    public <T, U> Tuple<T, U> newTuple(T first, U second) {
        return new Tuple<T, U>(first, second);
    }

    static {
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.OROR.getValue(), Tree.Kind.CONDITIONAL_OR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.ANDAND.getValue(), Tree.Kind.CONDITIONAL_AND);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.OR.getValue(), Tree.Kind.BITWISE_OR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.XOR.getValue(), Tree.Kind.BITWISE_XOR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.AND.getValue(), Tree.Kind.BITWISE_AND);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EQUAL.getValue(), Tree.Kind.EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.NOTEQUAL.getValue(), Tree.Kind.NOT_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EQUAL2.getValue(), Tree.Kind.STRICT_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.NOTEQUAL2.getValue(), Tree.Kind.STRICT_NOT_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.LT.getValue(), Tree.Kind.LESS_THAN);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.GT.getValue(), Tree.Kind.GREATER_THAN);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.LE.getValue(), Tree.Kind.LESS_THAN_OR_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.GE.getValue(), Tree.Kind.GREATER_THAN_OR_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SL.getValue(), Tree.Kind.LEFT_SHIFT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR.getValue(), Tree.Kind.RIGHT_SHIFT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR2.getValue(), Tree.Kind.UNSIGNED_RIGHT_SHIFT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.PLUS.getValue(), Tree.Kind.PLUS);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MINUS.getValue(), Tree.Kind.MINUS);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.STAR.getValue(), Tree.Kind.MULTIPLY);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EXP.getValue(), Tree.Kind.EXPONENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.DIV.getValue(), Tree.Kind.DIVIDE);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MOD.getValue(), Tree.Kind.REMAINDER);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EQU.getValue(), Tree.Kind.ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.STAR_EQU.getValue(), Tree.Kind.MULTIPLY_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EXP_EQU.getValue(), Tree.Kind.EXPONENT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.DIV_EQU.getValue(), Tree.Kind.DIVIDE_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MOD_EQU.getValue(), Tree.Kind.REMAINDER_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.PLUS_EQU.getValue(), Tree.Kind.PLUS_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MINUS_EQU.getValue(), Tree.Kind.MINUS_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SL_EQU.getValue(), Tree.Kind.LEFT_SHIFT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR_EQU.getValue(), Tree.Kind.RIGHT_SHIFT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR_EQU2.getValue(), Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.AND_EQU.getValue(), Tree.Kind.AND_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.XOR_EQU.getValue(), Tree.Kind.XOR_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.OR_EQU.getValue(), Tree.Kind.OR_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.COMMA.getValue(), Tree.Kind.COMMA_OPERATOR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptKeyword.INSTANCEOF.getValue(), Tree.Kind.INSTANCE_OF);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptKeyword.IN.getValue(), Tree.Kind.RELATIONAL_IN);
        PREFIX_KIND_BY_VALUE = ImmutableMap.builder().put((Object)JavaScriptPunctuator.INC.getValue(), (Object)Tree.Kind.PREFIX_INCREMENT).put((Object)JavaScriptPunctuator.DEC.getValue(), (Object)Tree.Kind.PREFIX_DECREMENT).put((Object)JavaScriptPunctuator.PLUS.getValue(), (Object)Tree.Kind.UNARY_PLUS).put((Object)JavaScriptPunctuator.MINUS.getValue(), (Object)Tree.Kind.UNARY_MINUS).put((Object)JavaScriptPunctuator.TILDA.getValue(), (Object)Tree.Kind.BITWISE_COMPLEMENT).put((Object)JavaScriptPunctuator.BANG.getValue(), (Object)Tree.Kind.LOGICAL_COMPLEMENT).put((Object)JavaScriptKeyword.DELETE.getValue(), (Object)Tree.Kind.DELETE).put((Object)JavaScriptKeyword.VOID.getValue(), (Object)Tree.Kind.VOID).put((Object)JavaScriptKeyword.TYPEOF.getValue(), (Object)Tree.Kind.TYPEOF).put((Object)JavaScriptKeyword.AWAIT.getValue(), (Object)Tree.Kind.AWAIT).build();
    }

    public static class Tuple<T, U> {
        private final T first;
        private final U second;

        public Tuple(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public T first() {
            return this.first;
        }

        public U second() {
            return this.second;
        }
    }

    static class ScriptVueElement
    extends VueElement {
        InternalSyntaxToken shebang;
        ModuleTree moduleTree;

        public ScriptVueElement(InternalSyntaxToken shebang, ModuleTree moduleTree) {
            this.shebang = shebang;
            this.moduleTree = moduleTree;
        }
    }

    static class VueElement {
        VueElement() {
        }
    }

    static class DotAccessTail
    implements ExpressionTail {
        SyntaxToken dot;
        IdentifierTree identifierTree;

        private DotAccessTail(SyntaxToken dot, IdentifierTree identifierTree) {
            this.dot = dot;
            this.identifierTree = identifierTree;
        }
    }

    static class BracketAccessTail
    implements ExpressionTail {
        SyntaxToken lBracket;
        ExpressionTree expressionTree;
        SyntaxToken rBracket;

        private BracketAccessTail(SyntaxToken lBracket, ExpressionTree expressionTree, SyntaxToken rBracket) {
            this.lBracket = lBracket;
            this.expressionTree = expressionTree;
            this.rBracket = rBracket;
        }
    }

    private static class TemplateLiteralTail
    implements ExpressionTail {
        TemplateLiteralTree templateLiteralTree;

        private TemplateLiteralTail(TemplateLiteralTree templateLiteralTree) {
            this.templateLiteralTree = templateLiteralTree;
        }
    }

    private static class ArgumentsTail
    implements ExpressionTail {
        ArgumentListTree argumentClause;

        private ArgumentsTail(ArgumentListTree argumentClause) {
            this.argumentClause = argumentClause;
        }
    }

    static interface ExpressionTail {
    }

    private static class ConditionalExpressionTail {
        InternalSyntaxToken queryToken;
        ExpressionTree trueExpr;
        InternalSyntaxToken colonToken;
        ExpressionTree falseExpr;

        ConditionalExpressionTail(InternalSyntaxToken queryToken, ExpressionTree trueExpr, InternalSyntaxToken colonToken, ExpressionTree falseExpr) {
            this.queryToken = queryToken;
            this.trueExpr = trueExpr;
            this.colonToken = colonToken;
            this.falseExpr = falseExpr;
        }
    }
}

