/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;

public enum KindSet implements Kinds
{
    ASSIGNMENT_KINDS(Tree.Kind.ASSIGNMENT, Tree.Kind.EXPONENT_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT),
    INC_DEC_KINDS(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT),
    EQUALITY_KINDS(Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO),
    FUNCTION_KINDS(Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GET_METHOD, Tree.Kind.SET_METHOD, Tree.Kind.ARROW_FUNCTION),
    LOOP_KINDS(Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT),
    LITERAL_KINDS(Tree.Kind.NULL_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.REGULAR_EXPRESSION_LITERAL, Tree.Kind.TEMPLATE_LITERAL, Tree.Kind.ARRAY_LITERAL, Tree.Kind.OBJECT_LITERAL);

    private Set<Tree.Kind> subKinds;

    private KindSet(Tree.Kind ... kinds) {
        this.subKinds = ImmutableSet.copyOf(Arrays.asList(kinds));
    }

    public Set<Tree.Kind> getSubKinds() {
        return this.subKinds;
    }

    @Override
    public boolean contains(Kinds other) {
        return this.equals(other) || other instanceof Tree.Kind && this.subKinds.contains(other);
    }
}

