/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public class CognitiveComplexity
extends DoubleDispatchVisitor {
    private FunctionVisitStrategy functionVisitStrategy = new FunctionVisit();
    private int nestingLevel = 0;
    private int ownComplexity = 0;
    private int nestedFunctionComplexity = 0;
    private boolean functionContainsStructuralComplexity = false;
    private List<IssueLocation> ownIssueLocations = new ArrayList<IssueLocation>();
    private List<IssueLocation> nestedFunctionsIssueLocations = new ArrayList<IssueLocation>();
    private FunctionTree topCognitiveScopeFunction = null;
    private Set<FunctionTree> nestedFunctions = new HashSet<FunctionTree>();
    private Deque<Tree> functionStack = new ArrayDeque<Tree>();
    private Set<Tree> logicalOperationsToIgnore = new HashSet<Tree>();

    public CognitiveComplexity(int declarationNestingLevel) {
        this.nestingLevel = declarationNestingLevel;
    }

    public CognitiveComplexity() {
    }

    public ComplexityData calculateFunctionComplexity(FunctionTree functionTree) {
        this.topCognitiveScopeFunction = functionTree;
        functionTree.accept(this);
        return this.buildComplexityData();
    }

    public ComplexityData calculateScriptComplexity(ScriptTree tree) {
        this.functionVisitStrategy = new NoFunctionVisit();
        tree.accept(this);
        List<FunctionTree> functions = FunctionVisitor.collectAllFunctions(tree);
        HashSet<ComplexityData> complexities = new HashSet<ComplexityData>();
        HashSet<FunctionTree> alreadyProcessedFunctions = new HashSet<FunctionTree>();
        for (FunctionTree function : functions) {
            if (alreadyProcessedFunctions.contains(function)) continue;
            int declarationNestingLevel = this.functionVisitStrategy.functionDeclarationNesting(function);
            ComplexityData complexityData = new CognitiveComplexity(declarationNestingLevel).calculateFunctionComplexity(function);
            complexities.add(complexityData);
            alreadyProcessedFunctions.addAll(complexityData.aggregatedNestedFunctions());
            complexityData.ignoredNestedFunctions.forEach(functionTree -> this.functionVisitStrategy.addDeclarationNesting((FunctionTree)functionTree, declarationNestingLevel));
        }
        Integer fileComplexity = complexities.stream().map(ComplexityData::complexity).reduce(0, Integer::sum) + this.ownComplexity;
        List<IssueLocation> locations = complexities.stream().flatMap(data -> data.secondaryLocations().stream()).collect(Collectors.toList());
        locations.addAll(this.ownIssueLocations);
        return new ComplexityData(fileComplexity, locations, Collections.emptySet(), Collections.emptySet());
    }

    public void clear() {
        this.topCognitiveScopeFunction = null;
    }

    private ComplexityData buildComplexityData() {
        int complexity;
        HashSet<FunctionTree> aggregatedNestedFunctions = new HashSet<FunctionTree>();
        ArrayList<IssueLocation> allIssueLocations = new ArrayList<IssueLocation>(this.ownIssueLocations);
        HashSet<FunctionTree> ignoredNestedFunctions = new HashSet();
        if (this.functionContainsStructuralComplexity) {
            complexity = this.ownComplexity + this.nestedFunctionComplexity;
            aggregatedNestedFunctions.addAll(this.nestedFunctions);
            allIssueLocations.addAll(this.nestedFunctionsIssueLocations);
        } else {
            complexity = this.ownComplexity;
            ignoredNestedFunctions = this.nestedFunctions;
        }
        return new ComplexityData(complexity, allIssueLocations, aggregatedNestedFunctions, ignoredNestedFunctions);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (CognitiveComplexity.isElseIf(tree)) {
            this.addComplexityWithoutNesting(tree.ifKeyword());
        } else {
            this.addComplexityWithNesting(tree.ifKeyword());
        }
        this.visit(tree.condition());
        this.visitWithNesting(tree.statement());
        this.visit(tree.elseClause());
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        if (tree.statement().is(Tree.Kind.IF_STATEMENT)) {
            this.visit(tree.statement());
        } else {
            this.addComplexityWithoutNesting(tree.elseKeyword());
            this.visitWithNesting(tree.statement());
        }
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.visitLoop(tree.whileKeyword(), tree.statement(), tree.condition());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.visitLoop(tree.doKeyword(), tree.statement(), tree.condition());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.visitLoop(tree.forKeyword(), tree.statement(), tree.init(), tree.condition(), tree.update());
    }

    @Override
    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.visitLoop(tree.forKeyword(), tree.statement(), tree.variableOrExpression(), tree.expression());
    }

    private void visitLoop(SyntaxToken secondaryLocationToken, Tree loopBody, Tree ... notNestedElements) {
        this.addComplexityWithNesting(secondaryLocationToken);
        this.visit(notNestedElements);
        this.visitWithNesting(loopBody);
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.addComplexityWithNesting(tree.catchKeyword());
        this.visitWithNesting(tree.block());
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.addComplexityWithNesting(tree.switchKeyword());
        ++this.nestingLevel;
        super.visitSwitchStatement(tree);
        --this.nestingLevel;
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            JavaScriptTree javaScriptTree = (JavaScriptTree)((Object)tree);
            ExpressionTree leftChild = CognitiveComplexity.removeParenthesis(tree.leftOperand());
            ExpressionTree rightChild = CognitiveComplexity.removeParenthesis(tree.rightOperand());
            boolean leftChildOfSameKind = leftChild.is(javaScriptTree.getKind());
            boolean rightChildOfSameKind = rightChild.is(javaScriptTree.getKind());
            if (rightChildOfSameKind) {
                this.logicalOperationsToIgnore.add(rightChild);
            }
            if (!this.logicalOperationsToIgnore.contains(tree) && !leftChildOfSameKind) {
                this.addComplexityWithoutNesting(tree.operatorToken());
            }
        }
        super.visitBinaryExpression(tree);
    }

    private static ExpressionTree removeParenthesis(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            return CognitiveComplexity.removeParenthesis(((ParenthesisedExpressionTree)expressionTree).expression());
        }
        return expressionTree;
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.addComplexityWithNesting(tree.queryToken());
        this.visit(tree.condition());
        this.visitWithNesting(tree.trueExpression());
        this.visitWithNesting(tree.falseExpression());
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.visitJumpStatement(tree.breakKeyword(), tree.labelToken());
        super.visitBreakStatement(tree);
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.visitJumpStatement(tree.continueKeyword(), tree.labelToken());
        super.visitContinueStatement(tree);
    }

    private void visitJumpStatement(SyntaxToken keyword, @Nullable SyntaxToken label) {
        if (label != null) {
            this.addComplexityWithoutNesting(keyword);
        }
    }

    private void visit(Tree ... trees) {
        for (Tree tree : trees) {
            if (tree == null) continue;
            tree.accept(this);
        }
    }

    private void visitWithNesting(Tree tree) {
        ++this.nestingLevel;
        tree.accept(this);
        --this.nestingLevel;
    }

    private void addComplexityWithNesting(SyntaxToken secondaryLocationToken) {
        if (this.isWithinTopCognitiveScope()) {
            this.functionContainsStructuralComplexity = true;
        }
        this.addComplexity(this.nestingLevel + 1, secondaryLocationToken);
    }

    private void addComplexityWithoutNesting(SyntaxToken secondaryLocationToken) {
        this.addComplexity(1, secondaryLocationToken);
    }

    private void addComplexity(int addedComplexity, SyntaxToken secondaryLocationToken) {
        IssueLocation secondaryLocation = new IssueLocation(secondaryLocationToken, CognitiveComplexity.secondaryMessage(addedComplexity));
        if (this.isWithinTopCognitiveScope()) {
            this.ownComplexity += addedComplexity;
            this.ownIssueLocations.add(secondaryLocation);
        } else {
            this.nestedFunctionComplexity += addedComplexity;
            this.nestedFunctionsIssueLocations.add(secondaryLocation);
        }
    }

    private boolean isWithinTopCognitiveScope() {
        return this.functionStack.isEmpty() || this.functionStack.peek().equals(this.topCognitiveScopeFunction);
    }

    private static String secondaryMessage(int complexity) {
        if (complexity == 1) {
            return "+1";
        }
        return String.format("+%s (incl. %s for nesting)", complexity, complexity - 1);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.functionVisitStrategy.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.functionVisitStrategy.visitArrowFunction(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.functionVisitStrategy.visitFunctionExpression(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.functionVisitStrategy.visitMethodDeclaration(tree);
    }

    @Override
    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.functionVisitStrategy.visitAccessorMethodDeclaration(tree);
    }

    private static boolean isElseIf(IfStatementTree tree) {
        return tree.parent().is(Tree.Kind.ELSE_CLAUSE);
    }

    private class FunctionVisit
    implements FunctionVisitStrategy {
        private FunctionVisit() {
        }

        private void visitFunction(FunctionTree tree, Runnable propagation) {
            CognitiveComplexity.this.functionStack.push(tree);
            if (!CognitiveComplexity.this.isWithinTopCognitiveScope()) {
                CognitiveComplexity.this.nestedFunctions.add(tree);
                CognitiveComplexity.this.nestingLevel++;
            }
            propagation.run();
            CognitiveComplexity.this.nestingLevel--;
            CognitiveComplexity.this.functionStack.pop();
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
            this.visitFunction(tree, () -> CognitiveComplexity.super.visitFunctionExpression(tree));
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
            this.visitFunction(tree, () -> CognitiveComplexity.super.visitFunctionDeclaration(tree));
        }

        @Override
        public void visitMethodDeclaration(MethodDeclarationTree tree) {
            this.visitFunction(tree, () -> CognitiveComplexity.super.visitMethodDeclaration(tree));
        }

        @Override
        public void visitArrowFunction(ArrowFunctionTree tree) {
            this.visitFunction(tree, () -> CognitiveComplexity.super.visitArrowFunction(tree));
        }

        @Override
        public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
            this.visitFunction(tree, () -> CognitiveComplexity.super.visitAccessorMethodDeclaration(tree));
        }
    }

    private class NoFunctionVisit
    implements FunctionVisitStrategy {
        Map<FunctionTree, Integer> functionDeclarationNesting = new HashMap<FunctionTree, Integer>();

        private NoFunctionVisit() {
        }

        private void saveNestingLevel(FunctionTree tree) {
            this.functionDeclarationNesting.put(tree, CognitiveComplexity.this.nestingLevel);
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
            this.saveNestingLevel(tree);
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
            this.saveNestingLevel(tree);
        }

        @Override
        public void visitMethodDeclaration(MethodDeclarationTree tree) {
            this.saveNestingLevel(tree);
        }

        @Override
        public void visitArrowFunction(ArrowFunctionTree tree) {
            this.saveNestingLevel(tree);
        }

        @Override
        public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
            this.saveNestingLevel(tree);
        }

        @Override
        public int functionDeclarationNesting(FunctionTree tree) {
            return this.functionDeclarationNesting.getOrDefault(tree, 0);
        }

        @Override
        public void addDeclarationNesting(FunctionTree functionTree, int declarationNestingLevel) {
            this.functionDeclarationNesting.put(functionTree, declarationNestingLevel);
        }
    }

    private static interface FunctionVisitStrategy {
        default public void visitFunctionExpression(FunctionExpressionTree tree) {
        }

        default public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        }

        default public void visitMethodDeclaration(MethodDeclarationTree tree) {
        }

        default public void visitArrowFunction(ArrowFunctionTree tree) {
        }

        default public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        }

        default public int functionDeclarationNesting(FunctionTree tree) {
            return 0;
        }

        default public void addDeclarationNesting(FunctionTree functionTree, int declarationNestingLevel) {
        }
    }

    private static class FunctionVisitor
    extends SubscriptionVisitor {
        private List<FunctionTree> collectedFunctions = new ArrayList<FunctionTree>();

        private FunctionVisitor() {
        }

        public static List<FunctionTree> collectAllFunctions(ScriptTree tree) {
            FunctionVisitor functionVisitor = new FunctionVisitor();
            functionVisitor.scanTree(tree);
            return functionVisitor.collectedFunctions;
        }

        @Override
        public Set<Tree.Kind> nodesToVisit() {
            return KindSet.FUNCTION_KINDS.getSubKinds();
        }

        @Override
        public void visitNode(Tree tree) {
            this.collectedFunctions.add((FunctionTree)tree);
        }
    }

    public static class ComplexityData {
        private int complexity;
        private List<IssueLocation> secondaryLocations;
        private Set<FunctionTree> aggregatedNestedFunctions;
        private Set<FunctionTree> ignoredNestedFunctions;

        ComplexityData(int complexity, List<IssueLocation> secondaryLocations, Set<FunctionTree> aggregatedNestedFunctions, Set<FunctionTree> ignoredNestedFunctions) {
            this.complexity = complexity;
            this.secondaryLocations = secondaryLocations;
            this.aggregatedNestedFunctions = aggregatedNestedFunctions;
            this.ignoredNestedFunctions = ignoredNestedFunctions;
        }

        public int complexity() {
            return this.complexity;
        }

        public List<IssueLocation> secondaryLocations() {
            return this.secondaryLocations;
        }

        public Set<FunctionTree> aggregatedNestedFunctions() {
            return this.aggregatedNestedFunctions;
        }
    }
}

