/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.ce.measure.RangeDistributionBuilder;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.utils.Version;
import org.sonar.javascript.compat.CompatibleInputFile;
import org.sonar.javascript.metrics.CognitiveComplexity;
import org.sonar.javascript.metrics.CommentLineVisitor;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.metrics.CounterVisitor;
import org.sonar.javascript.metrics.ExecutableLineVisitor;
import org.sonar.javascript.metrics.LineVisitor;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class MetricsVisitor
extends SubscriptionVisitor {
    private static final Number[] LIMITS_COMPLEXITY_FUNCTIONS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private static final Tree.Kind[] CLASS_NODES = new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION};
    private final SensorContext sensorContext;
    private final boolean saveExecutableLines;
    private InputFile inputFile;
    private final Boolean ignoreHeaderComments;
    private FileLinesContextFactory fileLinesContextFactory;
    private Map<InputFile, Set<Integer>> projectExecutableLines;
    private int classComplexity;
    private int functionComplexity;
    private RangeDistributionBuilder functionComplexityDistribution;
    private RangeDistributionBuilder fileComplexityDistribution;

    public MetricsVisitor(SensorContext context, Boolean ignoreHeaderComments, FileLinesContextFactory fileLinesContextFactory, boolean saveExecutableLines) {
        this.sensorContext = context;
        this.ignoreHeaderComments = ignoreHeaderComments;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.projectExecutableLines = new HashMap<InputFile, Set<Integer>>();
        this.saveExecutableLines = saveExecutableLines;
    }

    public Map<InputFile, Set<Integer>> executableLines() {
        return this.projectExecutableLines;
    }

    @Override
    public Set<Tree.Kind> nodesToVisit() {
        EnumSet<Tree.Kind> result = EnumSet.copyOf(KindSet.FUNCTION_KINDS.getSubKinds());
        result.addAll(Arrays.asList(CLASS_NODES));
        return result;
    }

    @Override
    public void leaveFile(Tree scriptTree) {
        this.saveComplexityMetrics(this.getContext());
        this.saveCounterMetrics(this.getContext());
        this.saveLineMetrics(this.getContext());
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(CLASS_NODES)) {
            this.classComplexity += new ComplexityVisitor(true).getComplexity(tree);
        } else if (tree.is(KindSet.FUNCTION_KINDS)) {
            int currentFunctionComplexity = new ComplexityVisitor(false).getComplexity(tree);
            this.functionComplexity += currentFunctionComplexity;
            this.functionComplexityDistribution.add((Number)currentFunctionComplexity);
        }
    }

    @Override
    public void visitFile(Tree scriptTree) {
        this.inputFile = ((CompatibleInputFile)this.getContext().getJavaScriptFile()).wrapped();
        this.init();
    }

    private void init() {
        this.classComplexity = 0;
        this.functionComplexity = 0;
        this.functionComplexityDistribution = new RangeDistributionBuilder(LIMITS_COMPLEXITY_FUNCTIONS);
        this.fileComplexityDistribution = new RangeDistributionBuilder(FILES_DISTRIB_BOTTOM_LIMITS);
    }

    private void saveCounterMetrics(TreeVisitorContext context) {
        CounterVisitor counter = new CounterVisitor(context.getTopTree());
        this.saveMetric(CoreMetrics.FUNCTIONS, counter.getFunctionNumber());
        this.saveMetric(CoreMetrics.STATEMENTS, counter.getStatementsNumber());
        this.saveMetric(CoreMetrics.CLASSES, counter.getClassNumber());
    }

    private void saveComplexityMetrics(TreeVisitorContext context) {
        int fileComplexity = new ComplexityVisitor(true).getComplexity(context.getTopTree());
        this.saveMetric(CoreMetrics.COMPLEXITY, fileComplexity);
        this.saveMetric(CoreMetrics.COMPLEXITY_IN_CLASSES, this.classComplexity);
        this.saveMetric(CoreMetrics.COMPLEXITY_IN_FUNCTIONS, this.functionComplexity);
        if (this.sensorContext.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)6, (int)3))) {
            int cognitiveComplexity = new CognitiveComplexity().calculateScriptComplexity(context.getTopTree()).complexity();
            this.saveMetric(CoreMetrics.COGNITIVE_COMPLEXITY, cognitiveComplexity);
        }
        this.sensorContext.newMeasure().on((InputComponent)this.inputFile).forMetric((Metric)CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION).withValue((Serializable)((Object)this.functionComplexityDistribution.build())).save();
        this.fileComplexityDistribution.add((Number)fileComplexity);
        this.sensorContext.newMeasure().on((InputComponent)this.inputFile).forMetric((Metric)CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION).withValue((Serializable)((Object)this.fileComplexityDistribution.build())).save();
    }

    private void saveLineMetrics(TreeVisitorContext context) {
        LineVisitor lineVisitor = new LineVisitor(context.getTopTree());
        Set<Integer> linesOfCode = lineVisitor.getLinesOfCode();
        this.saveMetric(CoreMetrics.NCLOC, lineVisitor.getLinesOfCodeNumber());
        CommentLineVisitor commentVisitor = new CommentLineVisitor(context.getTopTree(), this.ignoreHeaderComments);
        Set<Integer> commentLines = commentVisitor.getCommentLines();
        this.saveMetric(CoreMetrics.COMMENT_LINES, commentVisitor.getCommentLineNumber());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(this.inputFile);
        linesOfCode.forEach(line -> fileLinesContext.setIntValue("ncloc_data", line.intValue(), 1));
        commentLines.forEach(line -> fileLinesContext.setIntValue("comment_lines_data", line.intValue(), 1));
        Set<Integer> executableLines = new ExecutableLineVisitor(context.getTopTree()).getExecutableLines();
        this.projectExecutableLines.put(this.inputFile, executableLines);
        if (this.saveExecutableLines) {
            executableLines.stream().forEach(line -> fileLinesContext.setIntValue("executable_lines_data", line.intValue(), 1));
        }
        fileLinesContext.save();
    }

    private <T extends Serializable> void saveMetric(org.sonar.api.measures.Metric metric, T value) {
        this.sensorContext.newMeasure().withValue(value).forMetric((Metric)metric).on((InputComponent)this.inputFile).save();
    }

    public static Tree.Kind[] getClassNodes() {
        return CLASS_NODES;
    }
}

