/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public class FunctionDefiningModuleVisitor
extends SubscriptionVisitor {
    private boolean immediatelyInvokedFunctionExpression = false;
    private boolean amdPattern = false;
    private Set<FunctionTree> functionsDefiningModule = new HashSet<FunctionTree>();

    public static Set<FunctionTree> getFunctionsDefiningModule(ScriptTree scriptTree) {
        FunctionDefiningModuleVisitor functionDefiningModuleVisitor = new FunctionDefiningModuleVisitor();
        functionDefiningModuleVisitor.scanTree(scriptTree);
        return functionDefiningModuleVisitor.functionsDefiningModule;
    }

    @Override
    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().addAll(KindSet.FUNCTION_KINDS.getSubKinds()).add((Object[])new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION, Tree.Kind.NEW_EXPRESSION}).build();
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.CALL_EXPRESSION)) {
            CallExpressionTree callExpressionTree = (CallExpressionTree)tree;
            this.checkForImmediatelyInvokedFunction(callExpressionTree.callee());
            this.checkForAMDPattern(callExpressionTree);
            this.checkAngularModuleMethodCall(callExpressionTree);
            return;
        }
        if (tree.is(Tree.Kind.NEW_EXPRESSION)) {
            if (((NewExpressionTree)tree).argumentClause() != null) {
                this.checkForImmediatelyInvokedFunction(((NewExpressionTree)tree).expression());
            }
            return;
        }
        if (this.immediatelyInvokedFunctionExpression || this.amdPattern) {
            this.functionsDefiningModule.add((FunctionTree)tree);
            this.immediatelyInvokedFunctionExpression = false;
            this.amdPattern = false;
        }
    }

    private void checkForAMDPattern(CallExpressionTree tree) {
        if (tree.callee().is(Tree.Kind.IDENTIFIER_REFERENCE) && "define".equals(((IdentifierTree)tree.callee()).name())) {
            for (Tree tree2 : tree.argumentClause().arguments()) {
                if (!tree2.is(Tree.Kind.FUNCTION_EXPRESSION)) continue;
                this.amdPattern = true;
            }
        }
    }

    private void checkForImmediatelyInvokedFunction(ExpressionTree callee) {
        boolean parenthesisedFunctionCallee;
        Kinds[] funcExprKinds = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};
        boolean directFunctionCallee = callee.is(funcExprKinds);
        boolean bl = parenthesisedFunctionCallee = callee.is(Tree.Kind.PARENTHESISED_EXPRESSION) && ((ParenthesisedExpressionTree)callee).expression().is(funcExprKinds);
        if (directFunctionCallee || parenthesisedFunctionCallee) {
            this.immediatelyInvokedFunctionExpression = true;
        }
    }

    private void checkAngularModuleMethodCall(CallExpressionTree tree) {
        SeparatedList<ExpressionTree> arguments;
        DotMemberExpressionTree callee;
        if (tree.callee().is(Tree.Kind.DOT_MEMBER_EXPRESSION) && (callee = (DotMemberExpressionTree)tree.callee()).object().types().contains(Type.Kind.ANGULAR_MODULE) && !(arguments = tree.argumentClause().arguments()).isEmpty()) {
            Tree lastArgument = (Tree)arguments.get(arguments.size() - 1);
            this.checkArrayLiteral(lastArgument);
            this.checkSimpleArgument(lastArgument);
        }
    }

    private void checkArrayLiteral(Tree secondParameter) {
        List<ExpressionTree> elements;
        if (secondParameter.is(Tree.Kind.ARRAY_LITERAL) && !(elements = ((ArrayLiteralTree)secondParameter).elements()).isEmpty()) {
            this.checkSimpleArgument(elements.get(elements.size() - 1));
        }
    }

    private void checkSimpleArgument(Tree argument) {
        Type functionType;
        if (argument instanceof ExpressionTree && (functionType = ((ExpressionTree)argument).types().getUniqueType(Type.Kind.FUNCTION)) != null) {
            this.functionsDefiningModule.add(((FunctionType)functionType).functionTree());
        }
    }
}

