/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.flow;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.flow.FlowArrayTypeWithKeywordTree;
import org.sonar.plugins.javascript.api.tree.flow.FlowTypeTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class FlowArrayTypeWithKeywordTreeImpl
extends JavaScriptTree
implements FlowArrayTypeWithKeywordTree {
    private final SyntaxToken arrayToken;
    private final SyntaxToken leftBracketToken;
    private final FlowTypeTree type;
    private final SyntaxToken rightBracketToken;

    public FlowArrayTypeWithKeywordTreeImpl(SyntaxToken arrayToken, SyntaxToken leftBracketToken, FlowTypeTree type, SyntaxToken rightBracketToken) {
        this.arrayToken = arrayToken;
        this.leftBracketToken = leftBracketToken;
        this.type = type;
        this.rightBracketToken = rightBracketToken;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FLOW_ARRAY_TYPE_WITH_KEYWORD;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.arrayToken, this.leftBracketToken, this.type, this.rightBracketToken});
    }

    @Override
    public SyntaxToken arrayToken() {
        return this.arrayToken;
    }

    @Override
    public SyntaxToken leftBracketToken() {
        return this.leftBracketToken;
    }

    @Override
    public FlowTypeTree type() {
        return this.type;
    }

    @Override
    public SyntaxToken rightBracketToken() {
        return this.rightBracketToken;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitFlowArrayTypeWithKeywordTree(this);
    }
}

