/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.symbols.type.ArrayType;
import org.sonar.javascript.tree.symbols.type.PrimitiveType;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;

public class BuiltInMethods {
    private static final Map<String, Type> STRING_METHOD_RETURN_TYPES = ImmutableMap.builder().put((Object)"charAt", (Object)PrimitiveType.STRING).put((Object)"charCodeAt", (Object)PrimitiveType.NUMBER).put((Object)"concat", (Object)PrimitiveType.STRING).put((Object)"indexOf", (Object)PrimitiveType.NUMBER).put((Object)"lastIndexOf", (Object)PrimitiveType.NUMBER).put((Object)"localeCompare", (Object)PrimitiveType.NUMBER).put((Object)"replace", (Object)PrimitiveType.STRING).put((Object)"search", (Object)PrimitiveType.NUMBER).put((Object)"slice", (Object)PrimitiveType.STRING).put((Object)"split", (Object)ArrayType.create()).put((Object)"substr", (Object)PrimitiveType.STRING).put((Object)"substring", (Object)PrimitiveType.STRING).put((Object)"toLocaleLowerCase", (Object)PrimitiveType.STRING).put((Object)"toLocaleUpperCase", (Object)PrimitiveType.STRING).put((Object)"toLowerCase", (Object)PrimitiveType.STRING).put((Object)"toString", (Object)PrimitiveType.STRING).put((Object)"toUpperCase", (Object)PrimitiveType.STRING).put((Object)"trim", (Object)PrimitiveType.STRING).put((Object)"valueOf", (Object)PrimitiveType.STRING).build();

    private BuiltInMethods() {
    }

    @Nullable
    public static Type inferType(CallExpressionTree tree) {
        if (tree.callee().is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
            MemberExpressionTree callee = (MemberExpressionTree)tree.callee();
            if (callee.property().is(Tree.Kind.PROPERTY_IDENTIFIER)) {
                String methodName = ((IdentifierTree)callee.property()).name();
                return BuiltInMethods.inferStringMethodReturnType(callee.object(), methodName);
            }
        }
        return null;
    }

    @Nullable
    private static Type inferStringMethodReturnType(ExpressionTree object, String methodName) {
        if (object.types().contains(Type.Kind.STRING)) {
            return STRING_METHOD_RETURN_TYPES.get(methodName);
        }
        return null;
    }
}

