/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class UnaryMinusSymbolicValue
implements SymbolicValue {
    private final SymbolicValue operandValue;
    private static final Map<Constraint, Constraint> CONSTRAINT_TRANSITIONS = ImmutableMap.builder().put((Object)Constraint.POSITIVE_NUMBER_PRIMITIVE, (Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE).put((Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE, (Object)Constraint.POSITIVE_NUMBER_PRIMITIVE).put((Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO), (Object)Constraint.POSITIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO)).put((Object)Constraint.POSITIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO), (Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO)).put((Object)Constraint.ZERO, (Object)Constraint.ZERO).put((Object)Constraint.NAN, (Object)Constraint.NAN).build();

    public UnaryMinusSymbolicValue(SymbolicValue operandValue) {
        this.operandValue = operandValue;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        Constraint constraint = CONSTRAINT_TRANSITIONS.get(state.getConstraint(this.operandValue));
        if (constraint == null) {
            return Constraint.NUMBER_PRIMITIVE;
        }
        return constraint;
    }
}

