/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import java.util.List;
import java.util.Map;
import org.sonar.api.config.Settings;
import org.sonar.javascript.tree.impl.declaration.ClassTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrowFunctionTreeImpl;
import org.sonar.javascript.tree.impl.statement.CatchBlockTreeImpl;
import org.sonar.javascript.tree.symbols.GlobalVariableNames;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.SymbolModelBuilder;
import org.sonar.javascript.tree.symbols.type.ObjectType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ClassTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NameSpaceImportTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class HoistedSymbolVisitor
extends DoubleDispatchVisitor {
    private SymbolModelBuilder symbolModel;
    private Scope currentScope;
    private Map<Tree, Scope> treeScopeMap;
    private boolean insideForLoopVariable = false;
    private GlobalVariableNames globalVariableNames;

    public HoistedSymbolVisitor(Map<Tree, Scope> treeScopeMap, Settings settings) {
        this.treeScopeMap = treeScopeMap;
        this.globalVariableNames = new GlobalVariableNames(settings);
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.symbolModel = (SymbolModelBuilder)((Object)this.getContext().getSymbolModel());
        this.enterScope(tree);
        this.addExternalSymbols();
        super.visitScript(tree);
        this.leaveScope();
    }

    @Override
    public void visitBlock(BlockTree tree) {
        if (!this.treeScopeMap.containsKey(tree)) {
            super.visitBlock(tree);
        } else {
            this.enterScope(tree);
            super.visitBlock(tree);
            this.leaveScope();
        }
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.enterScope(tree);
        super.visitForStatement(tree);
        this.leaveScope();
    }

    @Override
    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.enterScope(tree);
        this.insideForLoopVariable = true;
        this.scan(tree.variableOrExpression());
        this.insideForLoopVariable = false;
        this.scan(tree.expression());
        this.scan(tree.statement());
        this.leaveScope();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan(tree.expression());
        this.enterScope(tree);
        this.scan(tree.cases());
        this.leaveScope();
    }

    @Override
    public void visitSpecifier(SpecifierTree tree) {
        if (tree.is(Tree.Kind.IMPORT_SPECIFIER)) {
            this.declareImportedSymbol(tree.rightName() == null ? tree.leftName() : tree.rightName());
        }
        super.visitSpecifier(tree);
    }

    @Override
    public void visitNameSpaceImport(NameSpaceImportTree tree) {
        this.declareImportedSymbol(tree.localName());
        super.visitNameSpaceImport(tree);
    }

    @Override
    public void visitImportClause(ImportClauseTree tree) {
        if (tree.firstSubClause().is(Tree.Kind.BINDING_IDENTIFIER)) {
            this.declareImportedSymbol((IdentifierTree)tree.firstSubClause());
        }
        super.visitImportClause(tree);
    }

    private void declareImportedSymbol(IdentifierTree identifierTree) {
        this.symbolModel.declareSymbol(identifierTree.name(), Symbol.Kind.IMPORT, this.symbolModel.globalScope()).addUsage(identifierTree, Usage.Kind.DECLARATION);
    }

    private void addExternalSymbols() {
        for (String globalSymbolName : this.globalVariableNames.names()) {
            this.symbolModel.declareExternalSymbol(globalSymbolName, Symbol.Kind.VARIABLE, this.currentScope);
        }
        Symbol windowSymbol = this.symbolModel.declareExternalSymbol("window", Symbol.Kind.VARIABLE, this.currentScope);
        windowSymbol.addType(ObjectType.WebApiType.WINDOW);
        this.addThisSymbol();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterScope(tree);
        this.declareParameters(((ParameterListTreeImpl)tree.parameterClause()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.enterScope(tree);
        this.declareParameters(((ParameterListTreeImpl)tree.parameterClause()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitAccessorMethodDeclaration(tree);
        this.leaveScope();
    }

    private void addFunctionBuiltInSymbols() {
        String arguments = "arguments";
        if (this.currentScope.symbols.get(arguments) == null) {
            this.symbolModel.declareExternalSymbol(arguments, Symbol.Kind.VARIABLE, this.currentScope);
        }
    }

    private void addThisSymbol() {
        Symbol thisSymbol = this.symbolModel.declareExternalSymbol("this", Symbol.Kind.VARIABLE, this.currentScope);
        thisSymbol.addType(ObjectType.create());
    }

    private void addThisSymbol(ClassTree tree) {
        Symbol thisSymbol = this.symbolModel.declareExternalSymbol("this", Symbol.Kind.VARIABLE, this.currentScope);
        thisSymbol.addType(((ClassTreeImpl)tree).classType().createObject());
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.enterScope(tree);
        for (IdentifierTree identifier : ((CatchBlockTreeImpl)tree).parameterIdentifiers()) {
            this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.currentScope).addUsage(identifier, Usage.Kind.DECLARATION);
        }
        super.visitCatchBlock(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.symbolModel.declareSymbol(tree.name().name(), Symbol.Kind.FUNCTION, this.getFunctionScope()).addUsage(tree.name(), Usage.Kind.DECLARATION);
        this.enterScope(tree);
        this.declareParameters(((ParameterListTreeImpl)tree.parameterClause()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        this.addThisSymbol();
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.enterScope(tree);
        this.declareParameters(((ArrowFunctionTreeImpl)tree).parameterIdentifiers());
        super.visitArrowFunction(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope(tree);
        IdentifierTree name = tree.name();
        if (name != null) {
            this.symbolModel.declareSymbol(name.name(), Symbol.Kind.FUNCTION, this.currentScope).addUsage(name, Usage.Kind.DECLARATION);
        }
        this.declareParameters(((ParameterListTreeImpl)tree.parameterClause()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        this.addThisSymbol();
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.enterScope(tree);
        this.addThisSymbol(tree);
        super.visitClass(tree);
        this.leaveScope();
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.addUsages(tree);
        super.visitVariableDeclaration(tree);
    }

    private void addUsages(VariableDeclarationTree tree) {
        Scope scope = this.currentScope;
        if (tree.is(Tree.Kind.VAR_DECLARATION)) {
            scope = this.getFunctionScope();
        }
        for (BindingElementTree bindingElement : tree.variables()) {
            Symbol.Kind variableKind = HoistedSymbolVisitor.getVariableKind(tree);
            if (bindingElement.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                for (IdentifierTree identifier : bindingElement.bindingIdentifiers()) {
                    this.symbolModel.declareSymbol(identifier.name(), variableKind, scope).addUsage(identifier, Usage.Kind.DECLARATION_WRITE);
                }
            }
            if (!bindingElement.is(Tree.Kind.BINDING_IDENTIFIER)) continue;
            IdentifierTree identifierTree = (IdentifierTree)bindingElement;
            this.symbolModel.declareSymbol(identifierTree.name(), variableKind, scope).addUsage(identifierTree, this.insideForLoopVariable ? Usage.Kind.DECLARATION_WRITE : Usage.Kind.DECLARATION);
        }
    }

    private void declareParameters(List<IdentifierTree> identifiers) {
        for (IdentifierTree identifier : identifiers) {
            this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.PARAMETER, this.currentScope).addUsage(identifier, Usage.Kind.LEXICAL_DECLARATION);
        }
    }

    private Scope getFunctionScope() {
        Scope scope = this.currentScope;
        while (scope.isBlock()) {
            scope = scope.outer();
        }
        return scope;
    }

    private static Symbol.Kind getVariableKind(VariableDeclarationTree declaration) {
        if (declaration.is(Tree.Kind.LET_DECLARATION)) {
            return Symbol.Kind.LET_VARIABLE;
        }
        if (declaration.is(Tree.Kind.CONST_DECLARATION)) {
            return Symbol.Kind.CONST_VARIABLE;
        }
        return Symbol.Kind.VARIABLE;
    }

    private void enterScope(Tree tree) {
        this.currentScope = this.treeScopeMap.get(tree);
        if (this.currentScope == null) {
            throw new IllegalStateException("No scope found for the tree");
        }
    }

    private void leaveScope() {
        if (this.currentScope != null) {
            this.currentScope = this.currentScope.outer();
        }
    }
}

