/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.declaration.ClassTreeImpl;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.type.AngularJS;
import org.sonar.javascript.tree.symbols.type.ArrayType;
import org.sonar.javascript.tree.symbols.type.Backbone;
import org.sonar.javascript.tree.symbols.type.BuiltInMethods;
import org.sonar.javascript.tree.symbols.type.ClassType;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.javascript.tree.symbols.type.JQuery;
import org.sonar.javascript.tree.symbols.type.ObjectType;
import org.sonar.javascript.tree.symbols.type.PrimitiveOperations;
import org.sonar.javascript.tree.symbols.type.PrimitiveType;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.javascript.tree.symbols.type.Utils;
import org.sonar.javascript.tree.symbols.type.WebAPI;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ClassTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class TypeVisitor
extends DoubleDispatchVisitor {
    private JQuery jQueryHelper;
    private boolean forLoopVariable = false;

    public TypeVisitor(@Nullable Configuration configuration) {
        this.jQueryHelper = configuration == null ? new JQuery("$, jQuery".split(", ")) : new JQuery(configuration.getStringArray("sonar.javascript.jQueryObjectAliases"));
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.inferType(tree.variable(), tree.expression());
        this.scan(tree.variable());
    }

    @Override
    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        this.inferType(tree.left(), tree.right());
        this.scan(tree.left());
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (tree.is(Tree.Kind.NUMERIC_LITERAL)) {
            TypeVisitor.addType(tree, PrimitiveType.NUMBER);
        } else if (tree.is(Tree.Kind.STRING_LITERAL)) {
            TypeVisitor.addType(tree, PrimitiveType.STRING);
        } else if (tree.is(Tree.Kind.BOOLEAN_LITERAL)) {
            TypeVisitor.addType(tree, PrimitiveType.BOOLEAN);
        }
    }

    @Override
    public void visitArrayLiteral(ArrayLiteralTree tree) {
        super.visitArrayLiteral(tree);
        TypeVisitor.addType(tree, ArrayType.create());
    }

    @Override
    public void visitObjectLiteral(ObjectLiteralTree tree) {
        super.visitObjectLiteral(tree);
        TypeVisitor.addType(tree, ObjectType.create(Type.Callability.NON_CALLABLE));
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        IdentifierTree name = tree.name();
        String nameName = name.name();
        Preconditions.checkState((boolean)name.symbol().isPresent(), (String)"Symbol has not been created for this function %s declared at line %s", (Object[])new Object[]{nameName, tree.firstToken().line()});
        name.symbol().get().addType(FunctionType.create(tree));
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        if (tree.name() != null) {
            TypeVisitor.addTypes(tree.name().symbol().get(), tree.types());
        }
        super.visitFunctionExpression(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        ClassType classType = ((ClassTreeImpl)tree).classType();
        if (tree.name() != null) {
            tree.name().symbol().get().addType(classType);
        }
        for (Tree element : tree.elements()) {
            if (!element.is(Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD)) continue;
            Tree name = ((MethodDeclarationTree)element).name();
            if (!name.is(Tree.Kind.PROPERTY_IDENTIFIER)) continue;
            Scope classScope = this.getContext().getSymbolModel().getScope(tree);
            classType.addMethod((IdentifierTree)name, FunctionType.create((FunctionTree)element), classScope);
        }
        super.visitClass(tree);
    }

    @Override
    public void visitCallExpression(CallExpressionTree tree) {
        super.visitCallExpression(tree);
        Type type = BuiltInMethods.inferType(tree);
        if (type != null) {
            TypeVisitor.addType(tree, type);
        } else if (this.jQueryHelper.isSelectorObject(tree)) {
            TypeVisitor.addType(tree, ObjectType.FrameworkType.JQUERY_SELECTOR_OBJECT);
        } else if (Backbone.isModel(tree)) {
            TypeVisitor.addType(tree, ObjectType.FrameworkType.BACKBONE_MODEL);
        } else if (WebAPI.isWindow(tree)) {
            TypeVisitor.addType(tree, ObjectType.WebApiType.WINDOW);
        } else if (WebAPI.isElement(tree)) {
            TypeVisitor.addType(tree, ObjectType.WebApiType.DOM_ELEMENT);
        } else if (WebAPI.isElementList(tree)) {
            TypeVisitor.addType(tree, ArrayType.create(ObjectType.WebApiType.DOM_ELEMENT));
        } else if (AngularJS.isModule(tree)) {
            TypeVisitor.addType(tree, ObjectType.FrameworkType.ANGULAR_MODULE);
        }
        TypeVisitor.inferParameterType(tree);
    }

    private static void addType(ExpressionTree tree, Type type) {
        ((TypableTree)((Object)tree)).add(type);
    }

    private static void inferParameterType(CallExpressionTree tree) {
        Type functionType = tree.callee().types().getUniqueType(Type.Kind.FUNCTION);
        if (functionType != null) {
            List<BindingElementTree> parameters = ((FunctionType)functionType).functionTree().parameterList();
            SeparatedList<ExpressionTree> arguments = tree.argumentClause().arguments();
            int minSize = arguments.size() < parameters.size() ? arguments.size() : parameters.size();
            for (int i = 0; i < minSize; ++i) {
                Tree currentParameter = parameters.get(i);
                TypeVisitor.inferParameterType(currentParameter, arguments, i);
            }
        }
    }

    private static void inferParameterType(Tree currentParameter, List<ExpressionTree> arguments, int index) {
        if (currentParameter.is(Tree.Kind.BINDING_IDENTIFIER)) {
            Optional<Symbol> symbol = ((IdentifierTree)currentParameter).symbol();
            if (symbol.isPresent()) {
                TypeVisitor.addTypes(symbol.get(), arguments.get(index).types());
            } else {
                throw new IllegalStateException(String.format("Parameter %s has no symbol associated with it (line %s)", ((IdentifierTree)currentParameter).name(), currentParameter.firstToken().line()));
            }
        }
    }

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        super.visitNewExpression(tree);
        TypeSet types = tree.expression().types();
        if (types.contains(Type.Kind.CLASS)) {
            Type classType = types.getUniqueType(Type.Kind.CLASS);
            if (classType != null) {
                TypeVisitor.addType(tree, ((ClassType)classType).createObject());
            }
        } else if (types.contains(Type.Kind.BACKBONE_MODEL)) {
            TypeVisitor.addType(tree, ObjectType.FrameworkType.BACKBONE_MODEL_OBJECT);
        } else if (Utils.identifierWithName(tree.expression(), "String")) {
            TypeVisitor.addType(tree, PrimitiveType.STRING);
        } else if (Utils.identifierWithName(tree.expression(), "Number")) {
            TypeVisitor.addType(tree, PrimitiveType.NUMBER);
        } else if (Utils.identifierWithName(tree.expression(), "Boolean")) {
            TypeVisitor.addType(tree, PrimitiveType.BOOLEAN);
        } else if (Utils.identifierWithName(tree.expression(), "Date")) {
            TypeVisitor.addType(tree, ObjectType.BuiltInObjectType.DATE);
        } else {
            TypeVisitor.addType(tree, ObjectType.create());
        }
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (this.jQueryHelper.isJQueryObject(tree)) {
            TypeVisitor.addType(tree, ObjectType.FrameworkType.JQUERY_OBJECT);
        }
        if (WebAPI.isDocument(tree)) {
            TypeVisitor.addType(tree, ObjectType.WebApiType.DOCUMENT);
        }
        if (this.forLoopVariable) {
            TypeVisitor.addType(tree, PrimitiveType.UNKNOWN);
        }
    }

    @Override
    public void visitParenthesisedExpression(ParenthesisedExpressionTree tree) {
        super.visitParenthesisedExpression(tree);
        TypeVisitor.addTypes(tree, tree.expression().types());
    }

    @Override
    public void visitMemberExpression(MemberExpressionTree tree) {
        super.visitMemberExpression(tree);
        if (WebAPI.isWindow(tree)) {
            TypeVisitor.addType(tree, ObjectType.WebApiType.WINDOW);
        }
        if (WebAPI.isElement(tree)) {
            TypeVisitor.addType(tree, ObjectType.WebApiType.DOM_ELEMENT);
        }
        if (tree.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION)) {
            Type arrayType = tree.object().types().getUniqueType(Type.Kind.ARRAY);
            if (arrayType != null && ((ArrayType)arrayType).elementType() != null) {
                TypeVisitor.addType(tree, ((ArrayType)arrayType).elementType());
            }
        } else {
            TypeVisitor.resolveObjectPropertyAccess(tree);
        }
    }

    private static void resolveObjectPropertyAccess(MemberExpressionTree tree) {
        String property;
        Symbol propertySymbol;
        ObjectType objectType = (ObjectType)tree.object().types().getUniqueType(Type.Kind.OBJECT);
        if (objectType != null && tree.property().is(Tree.Kind.PROPERTY_IDENTIFIER) && (propertySymbol = objectType.property(property = ((IdentifierTree)tree.property()).name())) != null) {
            TypeVisitor.addTypes(tree, propertySymbol.types());
            propertySymbol.addUsage((IdentifierTree)tree.property(), Usage.Kind.READ);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        Type resultType = PrimitiveOperations.getType(tree.leftOperand(), tree.rightOperand(), ((JavaScriptTree)((Object)tree)).getKind());
        if (resultType != null) {
            TypeVisitor.addType(tree, resultType);
        }
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        Type resultType = PrimitiveOperations.getType(tree);
        if (resultType != null) {
            TypeVisitor.addType(tree, resultType);
        }
    }

    @Override
    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.scan(tree.expression());
        this.forLoopVariable = true;
        this.scan(tree.variableOrExpression());
        this.forLoopVariable = false;
        this.scan(tree.statement());
    }

    private void inferType(Tree identifier, ExpressionTree assignedTree) {
        Optional<Symbol> symbol;
        super.scan(assignedTree);
        if (identifier instanceof IdentifierTree && (symbol = ((IdentifierTree)identifier).symbol()).isPresent()) {
            TypeVisitor.addTypes(symbol.get(), assignedTree.types());
        }
    }

    private static void addTypes(Symbol symbol, TypeSet types) {
        if (types.isEmpty()) {
            symbol.addType(PrimitiveType.UNKNOWN);
        } else {
            symbol.addTypes(types);
        }
    }

    private static void addTypes(ExpressionTree tree, TypeSet types) {
        for (Type type : types) {
            TypeVisitor.addType(tree, type);
        }
    }
}

