/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class IncDecSymbolicValue
implements SymbolicValue {
    private static final Table<Sign, Constraint, Constraint> CONSTRAINT_TRANSITIONS = HashBasedTable.create();
    private final Sign sign;
    private final SymbolicValue operandValue;

    public IncDecSymbolicValue(Sign sign, SymbolicValue operandValue) {
        this.sign = sign;
        this.operandValue = operandValue;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        Constraint constraint = (Constraint)CONSTRAINT_TRANSITIONS.get((Object)this.sign, (Object)state.getConstraint(this.operandValue));
        if (constraint == null) {
            return Constraint.NUMBER_PRIMITIVE;
        }
        return constraint;
    }

    public Sign sign() {
        return this.sign;
    }

    static {
        CONSTRAINT_TRANSITIONS.put((Object)Sign.PLUS, (Object)Constraint.POSITIVE_NUMBER_PRIMITIVE, (Object)Constraint.POSITIVE_NUMBER_PRIMITIVE);
        CONSTRAINT_TRANSITIONS.put((Object)Sign.PLUS, (Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE, (Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO));
        CONSTRAINT_TRANSITIONS.put((Object)Sign.PLUS, (Object)Constraint.ZERO, (Object)Constraint.POSITIVE_NUMBER_PRIMITIVE);
        CONSTRAINT_TRANSITIONS.put((Object)Sign.PLUS, (Object)Constraint.NAN, (Object)Constraint.NAN);
        CONSTRAINT_TRANSITIONS.put((Object)Sign.MINUS, (Object)Constraint.POSITIVE_NUMBER_PRIMITIVE, (Object)Constraint.POSITIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO));
        CONSTRAINT_TRANSITIONS.put((Object)Sign.MINUS, (Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE, (Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE);
        CONSTRAINT_TRANSITIONS.put((Object)Sign.MINUS, (Object)Constraint.ZERO, (Object)Constraint.NEGATIVE_NUMBER_PRIMITIVE);
        CONSTRAINT_TRANSITIONS.put((Object)Sign.MINUS, (Object)Constraint.NAN, (Object)Constraint.NAN);
    }

    public static enum Sign {
        PLUS,
        MINUS;

    }
}

