/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.symbols;

import com.google.common.annotations.Beta;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

@Beta
public class Usage {
    private final Kind kind;
    private final IdentifierTree identifierTree;
    private final Symbol symbol;

    Usage(IdentifierTree identifierTree, Kind kind, Symbol symbol) {
        this.kind = kind;
        this.identifierTree = identifierTree;
        this.symbol = symbol;
    }

    public Symbol symbol() {
        return this.symbol;
    }

    public Kind kind() {
        return this.kind;
    }

    public IdentifierTree identifierTree() {
        return this.identifierTree;
    }

    public boolean isDeclaration() {
        return this.kind == Kind.DECLARATION_WRITE || this.kind == Kind.DECLARATION || this.kind == Kind.LEXICAL_DECLARATION;
    }

    public boolean isWrite() {
        return this.kind == Kind.DECLARATION_WRITE || this.kind == Kind.WRITE || this.kind == Kind.READ_WRITE;
    }

    public boolean isRead() {
        return this.kind == Kind.READ || this.kind == Kind.READ_WRITE;
    }

    public static enum Kind {
        DECLARATION,
        DECLARATION_WRITE,
        LEXICAL_DECLARATION,
        WRITE,
        READ,
        READ_WRITE;

    }
}

