/*
 * SonarQube JavaScript Plugin
 * Copyright (C) 2011-2018 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.javascript.tree.impl.declaration;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportSubClauseTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ImportClauseTreeImpl extends JavaScriptTree implements ImportClauseTree {

  private final ImportSubClauseTree firstSubClause;
  private final SyntaxToken commaToken;
  private final ImportSubClauseTree secondSubClause;

  public ImportClauseTreeImpl(ImportSubClauseTree firstSubClause, SyntaxToken commaToken, ImportSubClauseTree secondSubClause) {
    this.firstSubClause = firstSubClause;
    this.commaToken = commaToken;
    this.secondSubClause = secondSubClause;
  }

  public ImportClauseTreeImpl(ImportSubClauseTree firstSubClause) {
    this.firstSubClause = firstSubClause;
    this.commaToken = null;
    this.secondSubClause = null;
  }

  @Override
  public ImportSubClauseTree firstSubClause() {
    return firstSubClause;
  }

  @Nullable
  @Override
  public SyntaxToken commaToken() {
    return commaToken;
  }

  @Nullable
  @Override
  public ImportSubClauseTree secondSubClause() {
    return secondSubClause;
  }


  @Override
  public Kind getKind() {
    return Kind.IMPORT_CLAUSE;
  }

  @Override
  public Iterator<Tree> childrenIterator() {
    return Iterators.forArray(firstSubClause, commaToken, secondSubClause);
  }

  @Override
  public void accept(DoubleDispatchVisitor visitor) {
    visitor.visitImportClause(this);
  }
}
