/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.JsCfgBlock;
import org.sonar.plugins.javascript.api.tree.Tree;

class JsCfgBranchingBlock
extends JsCfgBlock
implements CfgBranchingBlock {
    private JsCfgBlock trueSuccessor;
    private JsCfgBlock falseSuccessor;
    private Tree branchingTree;

    public JsCfgBranchingBlock(Tree branchingTree, JsCfgBlock trueSuccessor, JsCfgBlock falseSuccessor) {
        this.trueSuccessor = trueSuccessor;
        this.falseSuccessor = falseSuccessor;
        this.branchingTree = branchingTree;
    }

    @Override
    public JsCfgBlock trueSuccessor() {
        return this.trueSuccessor;
    }

    @Override
    public JsCfgBlock falseSuccessor() {
        return this.falseSuccessor;
    }

    @Override
    public Tree branchingTree() {
        return this.branchingTree;
    }

    public ImmutableSet<CfgBlock> successors() {
        return ImmutableSet.of((Object)this.trueSuccessor, (Object)this.falseSuccessor);
    }

    @Override
    public void replaceSuccessors(Map<JsCfgBlock, JsCfgBlock> replacements) {
        this.trueSuccessor = JsCfgBranchingBlock.replacement(this.trueSuccessor, replacements);
        this.falseSuccessor = JsCfgBranchingBlock.replacement(this.falseSuccessor, replacements);
    }
}

