/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.lexer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.lexer.JavaScriptTokenType;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class JavaScriptRegexpChannel
extends Channel<Lexer> {
    private static final String LINE_TERMINATOR_CHARACTERS = "\\r\\n\\u2028\\u2029";
    private static final String BACKSLASH_SEQUENCE = "\\\\[^\\r\\n\\u2028\\u2029]";
    private static final String CLASS = "\\[(?:[^\\]\\\\\\r\\n\\u2028\\u2029]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]";
    public static final String REGULAR_EXPRESSION = "\\/(?![*/])(?:[^\\\\\\[/\\r\\n\\u2028\\u2029]|\\[(?:[^\\]\\\\\\r\\n\\u2028\\u2029]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+";
    private final Channel<Lexer> delegate = RegexpChannelBuilder.regexp((TokenType)JavaScriptTokenType.REGULAR_EXPRESSION_LITERAL, (String[])new String[]{"\\/(?![*/])(?:[^\\\\\\[/\\r\\n\\u2028\\u2029]|\\[(?:[^\\]\\\\\\r\\n\\u2028\\u2029]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+"});
    private static final Set<String> WHOLE_TOKENS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"continue", (Object)"delete", (Object)"do", (Object)"else", (Object[])new String[]{"finally", "in", "instanceof", "return", "throw", "try", "typeof", "void", "+", "-", ".", "/", ",", "*"});
    private static final String[] ENDS = new String[]{"!", "%", "&", "(", ":", ";", "<", "=", ">", "?", "[", "^", "{", "|", "}", "~"};

    public boolean consume(CodeReader code, Lexer output) {
        Token lastToken;
        if (code.peek() == 47 && ((lastToken = JavaScriptRegexpChannel.getLastToken(output)) == null || JavaScriptRegexpChannel.guessNextIsRegexp(lastToken.getValue()))) {
            return this.delegate.consume(code, (Object)output);
        }
        return false;
    }

    private static Token getLastToken(Lexer output) {
        List tokens = output.getTokens();
        return tokens.isEmpty() ? null : (Token)tokens.get(tokens.size() - 1);
    }

    @VisibleForTesting
    static boolean guessNextIsRegexp(String preceder) {
        if (WHOLE_TOKENS.contains(preceder)) {
            return true;
        }
        for (String end : ENDS) {
            if (!preceder.endsWith(end)) continue;
            return true;
        }
        return false;
    }
}

