/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

public class ExecutableLineVisitor
extends SubscriptionVisitorCheck {
    private final Set<Integer> executableLines = new HashSet<Integer>();

    public ExecutableLineVisitor(Tree tree) {
        this.scanTree(tree);
    }

    @Override
    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.DEBUGGER_STATEMENT, (Object)Tree.Kind.VARIABLE_STATEMENT, (Object)Tree.Kind.LABELLED_STATEMENT, (Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.CONTINUE_STATEMENT, (Object)Tree.Kind.BREAK_STATEMENT, (Object[])new Tree.Kind[]{Tree.Kind.THROW_STATEMENT, Tree.Kind.WITH_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_IN_STATEMENT});
    }

    @Override
    public void visitNode(Tree tree) {
        this.executableLines.add(tree.firstToken().line());
    }

    public Set<Integer> getExecutableLines() {
        return this.executableLines;
    }
}

