/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.ProgramStateConstraints;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.SymbolicExecution;
import org.sonar.javascript.se.sv.FunctionSymbolicValue;
import org.sonar.javascript.se.sv.FunctionWithTreeSymbolicValue;
import org.sonar.javascript.se.sv.InstanceOfSymbolicValue;
import org.sonar.javascript.se.sv.LogicalNotSymbolicValue;
import org.sonar.javascript.se.sv.RelationalSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;
import org.sonar.javascript.se.sv.TypeOfSymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;

public class ExpressionStack {
    private static final ExpressionStack EMPTY = new ExpressionStack();
    private final Deque<SymbolicValue> stack;

    private ExpressionStack() {
        this.stack = new LinkedList<SymbolicValue>();
    }

    private ExpressionStack(Deque<SymbolicValue> stack) {
        this.stack = stack;
    }

    public static ExpressionStack emptyStack() {
        return EMPTY;
    }

    public ExpressionStack push(SymbolicValue newValue) {
        Deque<SymbolicValue> newStack = this.copy();
        newStack.push(newValue);
        return new ExpressionStack(newStack);
    }

    public ExpressionStack execute(ExpressionTree expression, ProgramStateConstraints constraints) {
        Deque<SymbolicValue> newStack = this.copy();
        Tree.Kind kind = ((JavaScriptTree)((Object)expression)).getKind();
        switch (kind) {
            case LOGICAL_COMPLEMENT: {
                SymbolicValue negatedValue = newStack.pop();
                newStack.push(LogicalNotSymbolicValue.create(negatedValue));
                break;
            }
            case TYPEOF: {
                newStack.push(new TypeOfSymbolicValue(newStack.pop()));
                break;
            }
            case NEW_EXPRESSION: {
                ExpressionStack.executeNewExpression((NewExpressionTree)expression, newStack);
                break;
            }
            case SPREAD_ELEMENT: 
            case VOID: 
            case AWAIT: {
                ExpressionStack.pop(newStack, 1);
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case DELETE: {
                ExpressionStack.pop(newStack, 1);
                newStack.push(new SymbolicValueWithConstraint(Constraint.BOOLEAN_PRIMITIVE));
                break;
            }
            case YIELD_EXPRESSION: {
                if (((YieldExpressionTree)expression).argument() != null) {
                    ExpressionStack.pop(newStack, 1);
                }
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case BITWISE_COMPLEMENT: {
                ExpressionStack.pop(newStack, 1);
                newStack.push(new SymbolicValueWithConstraint(Constraint.NUMBER_PRIMITIVE));
                break;
            }
            case CALL_EXPRESSION: {
                ExpressionStack.executeCallExpression((CallExpressionTree)expression, newStack, constraints);
                break;
            }
            case FUNCTION_EXPRESSION: 
            case GENERATOR_FUNCTION_EXPRESSION: 
            case ARROW_FUNCTION: {
                newStack.push(new FunctionWithTreeSymbolicValue((FunctionTree)((Object)expression)));
                break;
            }
            case THIS: 
            case SUPER: 
            case IMPORT: 
            case NEW_TARGET: 
            case JSX_SELF_CLOSING_ELEMENT: 
            case JSX_STANDARD_ELEMENT: 
            case JSX_SHORT_FRAGMENT_ELEMENT: 
            case FLOW_CASTING_EXPRESSION: {
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case CLASS_EXPRESSION: {
                newStack.push(new SymbolicValueWithConstraint(Constraint.OTHER_OBJECT));
                break;
            }
            case EXPONENT_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case TAGGED_TEMPLATE: 
            case EXPONENT: {
                ExpressionStack.pop(newStack, 2);
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case RELATIONAL_IN: {
                ExpressionStack.pop(newStack, 2);
                newStack.push(new SymbolicValueWithConstraint(Constraint.BOOLEAN_PRIMITIVE));
                break;
            }
            case INSTANCE_OF: {
                SymbolicValue constructorValue = newStack.pop();
                SymbolicValue objectValue = newStack.pop();
                newStack.push(new InstanceOfSymbolicValue(objectValue, constructorValue));
                break;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case STRICT_EQUAL_TO: 
            case STRICT_NOT_EQUAL_TO: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case GREATER_THAN_OR_EQUAL_TO: {
                SymbolicValue rightOperand = newStack.pop();
                SymbolicValue leftOperand = newStack.pop();
                newStack.push(RelationalSymbolicValue.create(kind, leftOperand, rightOperand));
                break;
            }
            case COMMA_OPERATOR: {
                SymbolicValue commaResult = newStack.pop();
                newStack.pop();
                newStack.push(commaResult);
                break;
            }
            case ASSIGNMENT: {
                SymbolicValue assignedValue = newStack.pop();
                newStack.pop();
                newStack.push(assignedValue);
                break;
            }
            case ARRAY_ASSIGNMENT_PATTERN: 
            case OBJECT_ASSIGNMENT_PATTERN: {
                newStack.push(UnknownSymbolicValue.UNKNOWN);
                break;
            }
            case PLUS_ASSIGNMENT: 
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case REMAINDER: 
            case MULTIPLY: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case BITWISE_AND: 
            case BITWISE_XOR: 
            case BITWISE_OR: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case PROPERTY_IDENTIFIER: 
            case BINDING_IDENTIFIER: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case CONDITIONAL_EXPRESSION: 
            case IDENTIFIER_REFERENCE: 
            case NULL_LITERAL: 
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case BOOLEAN_LITERAL: 
            case REGULAR_EXPRESSION_LITERAL: 
            case OBJECT_LITERAL: 
            case ARRAY_LITERAL: 
            case TEMPLATE_LITERAL: 
            case BRACKET_MEMBER_EXPRESSION: 
            case DOT_MEMBER_EXPRESSION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected kind of expression to execute: " + kind);
            }
        }
        return new ExpressionStack(newStack);
    }

    private static void executeNewExpression(NewExpressionTree newExpressionTree, Deque<SymbolicValue> newStack) {
        int arguments = newExpressionTree.argumentClause() == null ? 0 : newExpressionTree.argumentClause().arguments().size();
        ExpressionStack.pop(newStack, arguments);
        SymbolicValue constructor = newStack.pop();
        if (constructor instanceof FunctionSymbolicValue) {
            newStack.push(((FunctionSymbolicValue)constructor).instantiate());
        } else {
            newStack.push(new SymbolicValueWithConstraint(Constraint.OBJECT));
        }
    }

    private static void executeCallExpression(CallExpressionTree expression, Deque<SymbolicValue> newStack, ProgramStateConstraints constraints) {
        int argumentsNumber = expression.argumentClause().arguments().size();
        ArrayList<SymbolicValue> argumentValues = new ArrayList<SymbolicValue>();
        for (int i = 0; i < argumentsNumber; ++i) {
            argumentValues.add(newStack.pop());
        }
        argumentValues = Lists.reverse(argumentValues);
        SymbolicValue callee = newStack.pop();
        if (callee instanceof FunctionSymbolicValue) {
            newStack.push(((FunctionSymbolicValue)callee).call(argumentValues));
        } else if (callee instanceof FunctionWithTreeSymbolicValue) {
            FunctionTree functionTreeToExecute = ((FunctionWithTreeSymbolicValue)callee).getFunctionTree();
            if (functionTreeToExecute.body().is(Tree.Kind.BLOCK)) {
                ExpressionStack.runNestedSymbolicExecution(newStack, constraints, argumentValues, functionTreeToExecute);
            } else {
                ExpressionStack.pushUnknown(newStack);
            }
        } else {
            ExpressionStack.pushUnknown(newStack);
        }
    }

    private static void runNestedSymbolicExecution(Deque<SymbolicValue> newStack, ProgramStateConstraints constraints, List<SymbolicValue> argumentValues, FunctionTree functionTreeToExecute) {
        Scope scopeToExecute = functionTreeToExecute.scope();
        List<Constraint> argumentConstraints = argumentValues.stream().map(constraints::getConstraint).collect(Collectors.toList());
        ControlFlowGraph cfg = ControlFlowGraph.build((BlockTree)functionTreeToExecute.body());
        SymbolicExecution symbolicExecution = new SymbolicExecution(scopeToExecute, cfg, (List<SeCheck>)ImmutableList.of());
        ProgramState initialProgramState = ExpressionStack.initialProgramStateWithParameterConstraints(functionTreeToExecute, argumentConstraints);
        symbolicExecution.visitCfg(initialProgramState);
        newStack.push(new SymbolicValueWithConstraint(symbolicExecution.getReturnConstraint()));
    }

    private static ProgramState initialProgramStateWithParameterConstraints(FunctionTree functionTree, List<Constraint> argumentConstraints) {
        ProgramState initialProgramState = ProgramState.emptyState();
        Iterator<Constraint> arguments = argumentConstraints.iterator();
        for (Tree tree : functionTree.parameterList()) {
            if (!tree.is(Tree.Kind.BINDING_IDENTIFIER)) {
                return ProgramState.emptyState();
            }
            Constraint constraint = arguments.hasNext() ? arguments.next() : Constraint.UNDEFINED;
            initialProgramState = initialProgramState.newSymbolicValue(((IdentifierTree)tree).symbol().get(), constraint);
        }
        return initialProgramState;
    }

    private Deque<SymbolicValue> copy() {
        return new LinkedList<SymbolicValue>(this.stack);
    }

    public SymbolicValue peek() {
        return this.stack.peek();
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExpressionStack) {
            ExpressionStack other = (ExpressionStack)obj;
            return Objects.equals(this.stack, other.stack);
        }
        return false;
    }

    private static void pop(Deque<SymbolicValue> newStack, int n) {
        for (int i = 0; i < n; ++i) {
            newStack.pop();
        }
    }

    public SymbolicValue peek(int n) {
        Preconditions.checkArgument((n < this.stack.size() ? 1 : 0) != 0);
        Iterator<SymbolicValue> iterator = this.stack.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    private static void pushUnknown(Deque<SymbolicValue> newStack) {
        newStack.push(UnknownSymbolicValue.UNKNOWN);
    }

    public ExpressionStack removeLastValue() {
        return this.apply(Deque::pop);
    }

    public ExpressionStack apply(Consumer<Deque<SymbolicValue>> action) {
        Deque<SymbolicValue> newStack = this.copy();
        action.accept(newStack);
        return new ExpressionStack(newStack);
    }

    public String toString() {
        return this.stack.toString();
    }
}

