/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.points;

import java.util.EnumSet;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ExpressionStack;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.ObjectSymbolicValue;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;

public class MemberProgramPoint
implements ProgramPoint {
    private final Tree element;
    private PropertyResolutionMode mode = PropertyResolutionMode.ASSUME_PARTIAL_PROPERTY_KNOWLEDGE;

    public MemberProgramPoint(Tree element) {
        this.element = element;
    }

    public static boolean originatesFrom(Tree element) {
        return element.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION);
    }

    @Override
    public Optional<ProgramState> execute(ProgramState state) {
        ExpressionStack newExpressionStack;
        Optional<ProgramState> newState;
        ExpressionStack expressionStack = state.getStack();
        if (this.element.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION)) {
            SymbolicValue objectValue = state.peekStack(1);
            newState = state.constrain(objectValue, Constraint.NOT_NULLY);
            if (!newState.isPresent()) {
                return newState;
            }
            newExpressionStack = expressionStack.apply(stack -> {
                stack.pop();
                stack.pop();
                stack.push(UnknownSymbolicValue.UNKNOWN);
            });
        } else {
            SymbolicValue objectValue = state.peekStack(0);
            newState = state.constrain(objectValue, Constraint.NOT_NULLY);
            if (!newState.isPresent()) {
                return newState;
            }
            newExpressionStack = expressionStack.apply(stack -> {
                stack.pop();
                stack.push(this.resolvePropertyValue((ProgramState)newState.get(), objectValue));
            });
        }
        return Optional.of(newState.get().withStack(newExpressionStack));
    }

    public Optional<ProgramState> executeStrictMode(ProgramState state) {
        this.mode = PropertyResolutionMode.ASSUME_FULL_PROPERTY_KNOWLEDGE;
        Optional<ProgramState> result = this.execute(state);
        this.mode = PropertyResolutionMode.ASSUME_PARTIAL_PROPERTY_KNOWLEDGE;
        return result;
    }

    private SymbolicValue resolvePropertyValue(ProgramState state, SymbolicValue objectValue) {
        SymbolicValue propertyValue;
        String propertyName = ((DotMemberExpressionTree)this.element).property().name();
        if (objectValue instanceof ObjectSymbolicValue && !UnknownSymbolicValue.UNKNOWN.equals(propertyValue = this.mode.resolveObjectPropertyValue((ObjectSymbolicValue)objectValue, propertyName))) {
            return propertyValue;
        }
        Type type = state.getConstraint(objectValue).type();
        if (type != null) {
            return this.mode.resolvePrototypePropertyValue(type, propertyName);
        }
        return UnknownSymbolicValue.UNKNOWN;
    }

    private static enum PropertyResolutionMode {
        ASSUME_PARTIAL_PROPERTY_KNOWLEDGE{

            @Override
            SymbolicValue resolveObjectPropertyValue(ObjectSymbolicValue objectValue, String propertyName) {
                SymbolicValue value = objectValue.getPropertyValue(propertyName);
                return SpecialSymbolicValue.UNDEFINED.equals(value) ? UnknownSymbolicValue.UNKNOWN : value;
            }

            @Override
            SymbolicValue resolvePrototypePropertyValue(Type type, String propertyName) {
                SymbolicValue value = type.getPropertyValue(propertyName);
                return SpecialSymbolicValue.UNDEFINED.equals(value) ? UnknownSymbolicValue.UNKNOWN : value;
            }
        }
        ,
        ASSUME_FULL_PROPERTY_KNOWLEDGE{
            private final EnumSet<Type> primitiveTypes = EnumSet.of(Type.NUMBER_PRIMITIVE, new Type[]{Type.NUMBER_OBJECT, Type.STRING_PRIMITIVE, Type.STRING_OBJECT, Type.BOOLEAN_PRIMITIVE, Type.BOOLEAN_OBJECT});

            @Override
            SymbolicValue resolveObjectPropertyValue(ObjectSymbolicValue objectValue, String propertyName) {
                return objectValue.getPropertyValue(propertyName);
            }

            @Override
            SymbolicValue resolvePrototypePropertyValue(Type type, String propertyName) {
                if (this.primitiveTypes.contains((Object)type)) {
                    return type.getPropertyValue(propertyName);
                }
                return ASSUME_PARTIAL_PROPERTY_KNOWLEDGE.resolvePrototypePropertyValue(type, propertyName);
            }
        };


        abstract SymbolicValue resolveObjectPropertyValue(ObjectSymbolicValue var1, String var2);

        abstract SymbolicValue resolvePrototypePropertyValue(Type var1, String var2);
    }
}

