/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.statement;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class BlockTreeImpl
extends JavaScriptTree
implements BlockTree {
    private final SyntaxToken openCurlyBrace;
    private final List<StatementTree> statements;
    private final SyntaxToken closeCurlyBrace;

    public BlockTreeImpl(InternalSyntaxToken openCurlyBrace, List<StatementTree> statements, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.statements = statements;
        this.closeCurlyBrace = closeCurlyBrace;
    }

    public BlockTreeImpl(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.statements = Collections.emptyList();
        this.closeCurlyBrace = closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BLOCK;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBrace;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBrace;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openCurlyBrace), this.statements.iterator(), (Iterator)Iterators.singletonIterator((Object)this.closeCurlyBrace));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitBlock(this);
    }
}

