/*
 * SonarQube JavaScript Plugin
 * Copyright (C) 2011-2019 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectAssignmentPatternPairElementTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ObjectAssignmentPatternPairElementTreeImpl extends JavaScriptTree implements ObjectAssignmentPatternPairElementTree {

  private final IdentifierTree key;
  private final SyntaxToken colonToken;
  private final Tree element;

  public ObjectAssignmentPatternPairElementTreeImpl(IdentifierTree key, SyntaxToken colonToken, Tree element) {
    this.key = key;
    this.colonToken = colonToken;
    this.element = element;
  }

  @Override
  public Kind getKind() {
    return Kind.OBJECT_ASSIGNMENT_PATTERN_PAIR_ELEMENT;
  }

  @Override
  public Iterator<Tree> childrenIterator() {
    return Iterators.forArray(key, colonToken, element);
  }

  @Override
  public IdentifierTree key() {
    return key;
  }

  @Override
  public SyntaxToken colonToken() {
    return colonToken;
  }

  @Override
  public Tree element() {
    return element;
  }

  @Override
  public void accept(DoubleDispatchVisitor visitor) {
    visitor.visitObjectAssignmentPatternPairElement(this);
  }
}
