/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.se.BlockExecution;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.LiveVariableAnalysis;
import org.sonar.javascript.se.LocalVariables;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.limitations.CrossProceduralLimitation;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ArrayBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayAssignmentPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentPatternRestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.InitializedAssignmentPatternElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectAssignmentPatternPairElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectAssignmentPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.flow.FlowTypedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;

public class SymbolicExecution {
    private static final int MAX_BLOCK_EXECUTIONS = 10000;
    private final CfgBlock cfgStartBlock;
    private final ControlFlowGraph cfg;
    private final Set<Symbol> trackedVariables;
    private final Set<Symbol> functionParameters;
    private final Scope functionScope;
    private final boolean isAsync;
    private final Deque<BlockExecution> workList = new ArrayDeque<BlockExecution>();
    private final SetMultimap<Tree, Constraint> conditionResults = HashMultimap.create();
    private final Set<BlockExecution> alreadyProcessed = new HashSet<BlockExecution>();
    private final List<SeCheck> checks;
    private final LiveVariableAnalysis liveVariableAnalysis;
    private Constraint returnConstraint = null;
    private boolean executionInterrupted = false;

    public SymbolicExecution(Scope functionScope, ControlFlowGraph cfg, List<SeCheck> checks, boolean isAsync) {
        this.cfgStartBlock = cfg.start();
        this.cfg = cfg;
        LocalVariables localVariables = new LocalVariables(functionScope, cfg);
        this.trackedVariables = localVariables.trackableVariables();
        this.functionParameters = localVariables.functionParameters();
        this.liveVariableAnalysis = LiveVariableAnalysis.createForSymbolicExecution(cfg, functionScope);
        this.functionScope = functionScope;
        this.checks = checks;
        this.isAsync = isAsync;
    }

    public void visitCfg(ProgramState initialStateWithParameters) {
        for (SeCheck check : this.checks) {
            check.startOfExecution(this.functionScope);
        }
        this.workList.addLast(new BlockExecution(this.cfgStartBlock, this.initialState(initialStateWithParameters)));
        for (int i = 0; i < 10000 && !this.workList.isEmpty(); ++i) {
            BlockExecution blockExecution = this.workList.removeFirst();
            if (this.alreadyProcessed.contains(blockExecution)) continue;
            if (SymbolicExecution.hasTryBranchingTree(blockExecution.block())) {
                this.executionInterrupted = true;
                return;
            }
            this.execute(blockExecution);
            this.alreadyProcessed.add(blockExecution);
        }
        if (this.workList.isEmpty()) {
            for (SeCheck check : this.checks) {
                check.checkConditions(this.conditionResults.asMap());
                check.endOfExecution(this.functionScope);
            }
        } else {
            this.executionInterrupted = true;
        }
    }

    public Constraint getReturnConstraint() {
        if (this.executionInterrupted) {
            return Constraint.ANY_VALUE;
        }
        if (this.returnConstraint == null) {
            return Constraint.UNDEFINED;
        }
        return this.returnConstraint;
    }

    private void addReturnConstraint(Constraint constraint) {
        this.returnConstraint = this.returnConstraint == null ? constraint : this.returnConstraint.or(constraint);
    }

    private static boolean hasTryBranchingTree(CfgBlock block) {
        if (block instanceof CfgBranchingBlock) {
            return ((CfgBranchingBlock)block).branchingTree().is(Tree.Kind.TRY_STATEMENT);
        }
        return false;
    }

    private ProgramState initialState(ProgramState initialStateWithParameters) {
        ProgramState initialState = initialStateWithParameters;
        for (Symbol localVar : this.trackedVariables) {
            Constraint initialConstraint = null;
            if (!SymbolicExecution.symbolIs(localVar, Symbol.Kind.FUNCTION, Symbol.Kind.IMPORT, Symbol.Kind.CLASS) && !this.functionParameters.contains(localVar)) {
                initialConstraint = Constraint.UNDEFINED;
            } else if (SymbolicExecution.symbolIs(localVar, Symbol.Kind.FUNCTION)) {
                initialConstraint = Constraint.FUNCTION;
            } else if (SymbolicExecution.symbolIs(localVar, Symbol.Kind.CLASS)) {
                initialConstraint = Constraint.OTHER_OBJECT;
            }
            if (initialState.getSymbolicValue(localVar) != null) continue;
            initialState = initialState.newSymbolicValue(localVar, initialConstraint);
        }
        Symbol arguments = this.functionScope.getSymbol("arguments");
        if (arguments != null) {
            initialState = initialState.newSymbolicValue(arguments, Constraint.OBJECT);
        }
        initialState = this.initiateFunctionDeclarationSymbols(initialState);
        return initialState;
    }

    private ProgramState initiateFunctionDeclarationSymbols(ProgramState initialState) {
        ProgramState programStateWithFunctions = initialState;
        for (CfgBlock cfgBlock : this.cfg.blocks()) {
            for (Tree element : cfgBlock.elements()) {
                if (!element.is(Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION)) continue;
                FunctionDeclarationTree functionDeclaration = (FunctionDeclarationTree)element;
                Symbol symbol = functionDeclaration.name().symbol().get();
                programStateWithFunctions = programStateWithFunctions.newFunctionSymbolicValue(symbol, functionDeclaration);
            }
        }
        return programStateWithFunctions;
    }

    private static boolean symbolIs(Symbol symbol, Symbol.Kind ... kinds) {
        for (Symbol.Kind kind : kinds) {
            if (!symbol.kind().equals((Object)kind)) continue;
            return true;
        }
        return false;
    }

    private void execute(BlockExecution blockExecution) {
        CfgBlock block = blockExecution.block();
        ProgramState currentState = blockExecution.state();
        boolean stopExploring = false;
        for (Tree element : block.elements()) {
            Optional<ProgramState> executionResult;
            ProgramPoint programPoint = ProgramPoint.create(element, this);
            this.beforeBlockElement(currentState, element, programPoint);
            if (element.is(Tree.Kind.RETURN_STATEMENT)) {
                ReturnStatementTree returnStatement = (ReturnStatementTree)element;
                if (returnStatement.expression() != null) {
                    this.addReturnConstraint(currentState.getConstraint(currentState.peekStack()));
                } else {
                    this.addReturnConstraint(Constraint.UNDEFINED);
                }
            }
            if (!(executionResult = programPoint.execute(currentState)).isPresent()) {
                stopExploring = true;
                break;
            }
            currentState = executionResult.get();
            if (element instanceof ExpressionTree && !element.is(Tree.Kind.CLASS_DECLARATION)) {
                currentState = currentState.execute((ExpressionTree)element);
            }
            currentState = this.executeAssignment(currentState, element);
            this.afterBlockElement(currentState, element);
            if (!SymbolicExecution.isProducingUnconsumedValue(element)) continue;
            currentState = currentState.clearStack(element);
        }
        this.checkForImplicitReturn(block);
        if (!stopExploring) {
            this.handleSuccessors(block, currentState);
        }
    }

    private ProgramState executeAssignment(ProgramState state, Tree element) {
        ProgramState currentState = state;
        if (element.is(KindSet.ASSIGNMENT_KINDS)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)element;
            currentState = this.assignment(currentState, assignment.variable());
        } else if (element.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
            currentState = this.executeInitializedBinding((InitializedBindingElementTree)element, currentState);
        } else if (element.is(Tree.Kind.ARRAY_ASSIGNMENT_PATTERN)) {
            ArrayAssignmentPatternTree arrayAssignmentPatternTree = (ArrayAssignmentPatternTree)element;
            List assignedElements = SymbolicExecution.presentsOf(arrayAssignmentPatternTree.elements());
            currentState = this.createSymbolicValuesForTrackedVariables(assignedElements, currentState);
        } else if (element.is(Tree.Kind.OBJECT_ASSIGNMENT_PATTERN)) {
            ObjectAssignmentPatternTree objectAssignmentPatternTree = (ObjectAssignmentPatternTree)element;
            SeparatedList<Tree> assignedElements = objectAssignmentPatternTree.elements();
            currentState = this.createSymbolicValuesForTrackedVariables(assignedElements, currentState);
        } else if (element.is(Tree.Kind.ARRAY_BINDING_PATTERN)) {
            ArrayBindingPatternTree arrayBindingPatternTree = (ArrayBindingPatternTree)element;
            List assignedElements = SymbolicExecution.presentsOf(arrayBindingPatternTree.elements());
            currentState = this.createSymbolicValuesForTrackedVariables(assignedElements, currentState);
        } else if (element.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
            ObjectBindingPatternTree objectBindingPatternTree = (ObjectBindingPatternTree)element;
            SeparatedList<BindingElementTree> assignedElements = objectBindingPatternTree.elements();
            currentState = this.createSymbolicValuesForTrackedVariables(assignedElements, currentState);
        }
        return currentState;
    }

    private static <T extends Tree> List<T> presentsOf(List<Optional<T>> list) {
        LinkedList<Tree> newList = new LinkedList<Tree>();
        for (Optional<T> element : list) {
            if (!element.isPresent()) continue;
            newList.add((Tree)element.get());
        }
        return newList;
    }

    private void checkForImplicitReturn(CfgBlock block) {
        boolean blockLeadsToEnd = block.successors().contains(this.cfg.end());
        if (blockLeadsToEnd) {
            if (this.isAsync) {
                this.addReturnConstraint(Constraint.OBJECT);
                return;
            }
            List<Tree> elements = block.elements();
            Tree lastElement = elements.get(elements.size() - 1);
            if (!lastElement.is(Tree.Kind.RETURN_STATEMENT)) {
                this.addReturnConstraint(Constraint.UNDEFINED);
            }
        }
    }

    private ProgramState executeInitializedBinding(InitializedBindingElementTree initializedBindingElementTree, ProgramState programState) {
        ProgramState newProgramState;
        if (initializedBindingElementTree.parent().is(Tree.Kind.OBJECT_BINDING_PATTERN, Tree.Kind.ARRAY_BINDING_PATTERN, Tree.Kind.BINDING_PROPERTY)) {
            newProgramState = programState.removeLastValue();
        } else {
            BindingElementTree variable = initializedBindingElementTree.left();
            newProgramState = this.executeInitializer(programState, variable);
            newProgramState = newProgramState.clearStack(initializedBindingElementTree);
        }
        return newProgramState;
    }

    private ProgramState executeInitializer(ProgramState programState, BindingElementTree variable) {
        if (variable.is(Tree.Kind.BINDING_IDENTIFIER)) {
            return this.assignment(programState, variable);
        }
        if (variable.is(Tree.Kind.FLOW_TYPED_BINDING_ELEMENT)) {
            return this.executeInitializer(programState, ((FlowTypedBindingElementTree)variable).bindingElement());
        }
        return programState;
    }

    private static boolean isProducingUnconsumedValue(Tree element) {
        if (element instanceof ExpressionTree) {
            Tree tree = SymbolicExecution.getParentIfParenthesised(element);
            Tree parent = tree.parent();
            if (parent.is(Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.CASE_CLAUSE, Tree.Kind.WITH_STATEMENT)) {
                return true;
            }
            if (parent.is(Tree.Kind.FOR_STATEMENT)) {
                ForStatementTree forStatementTree = (ForStatementTree)parent;
                return tree.equals(forStatementTree.init()) || tree.equals(forStatementTree.update());
            }
        }
        return false;
    }

    private static Tree getParentIfParenthesised(Tree tree) {
        Tree syntaxTree = tree;
        while (syntaxTree.parent().is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            syntaxTree = syntaxTree.parent();
        }
        return syntaxTree;
    }

    private ProgramState createSymbolicValuesForTrackedVariables(List<? extends Tree> trees, ProgramState state) {
        ProgramState newState = state;
        for (Tree tree : trees) {
            Symbol trackedVariable = this.trackedVariable(tree);
            if (trackedVariable == null) continue;
            newState = newState.newSymbolicValue(trackedVariable, null);
        }
        return newState;
    }

    private void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        for (SeCheck check : this.checks) {
            check.beforeBlockElement(currentState, element, programPoint);
        }
    }

    private void afterBlockElement(ProgramState currentState, Tree element) {
        for (SeCheck check : this.checks) {
            check.afterBlockElement(currentState, element);
        }
    }

    private void pushAllSuccessors(CfgBlock block, ProgramState currentState) {
        for (CfgBlock successor : block.successors()) {
            this.pushSuccessor(successor, currentState);
        }
    }

    private void pushSuccessor(CfgBlock successor, @Nullable ProgramState currentState) {
        if (currentState != null) {
            Set<Symbol> liveInSymbols = this.liveVariableAnalysis.getLiveInSymbols(successor);
            this.workList.addLast(new BlockExecution(successor, currentState.removeSymbols(liveInSymbols)));
        }
    }

    private void handleSuccessors(CfgBlock block, ProgramState incomingState) {
        ProgramState currentState = incomingState;
        boolean shouldPushAllSuccessors = true;
        if (block instanceof CfgBranchingBlock) {
            CfgBranchingBlock branchingBlock = (CfgBranchingBlock)block;
            Tree branchingTree = branchingBlock.branchingTree();
            if (branchingTree.is(Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
                this.pushConditionSuccessors(branchingBlock, currentState);
                shouldPushAllSuccessors = false;
            } else if (branchingTree.is(Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT)) {
                ForObjectStatementTree forTree = (ForObjectStatementTree)branchingTree;
                Tree variable = forTree.variableOrExpression();
                if (variable.is(Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION)) {
                    VariableDeclarationTree declaration = (VariableDeclarationTree)variable;
                    variable = (Tree)declaration.variables().get(0);
                }
                currentState = this.newSymbolicValue(currentState, variable);
                Constraint expressionConstraint = Constraint.ANY_VALUE;
                if (forTree.expression().is(Tree.Kind.IDENTIFIER_REFERENCE)) {
                    SymbolicValue expressionSV = currentState.getSymbolicValue((IdentifierTree)forTree.expression(), this);
                    expressionConstraint = currentState.getConstraint(expressionSV);
                }
                if (expressionConstraint.isStricterOrEqualTo(Constraint.NULL_OR_UNDEFINED)) {
                    this.pushSuccessor(branchingBlock.falseSuccessor(), currentState);
                    shouldPushAllSuccessors = false;
                }
            }
        }
        if (shouldPushAllSuccessors) {
            this.pushAllSuccessors(block, currentState);
        }
    }

    private void pushConditionSuccessors(CfgBranchingBlock block, ProgramState currentState) {
        Optional<ProgramState> constrainedFalsePS;
        SymbolicValue conditionSymbolicValue = currentState.peekStack();
        Tree lastElement = block.elements().get(block.elements().size() - 1);
        ProgramState programStateForBranching = new CrossProceduralLimitation().prepareForBranching(lastElement, currentState);
        Optional<ProgramState> constrainedTruePS = programStateForBranching.constrain(conditionSymbolicValue, Constraint.TRUTHY);
        if (constrainedTruePS.isPresent()) {
            this.pushConditionSuccessor(block.trueSuccessor(), constrainedTruePS.get(), conditionSymbolicValue, Constraint.TRUTHY, block.branchingTree());
            this.conditionResults.put((Object)lastElement, (Object)Constraint.TRUTHY);
        }
        if ((constrainedFalsePS = programStateForBranching.constrain(conditionSymbolicValue, Constraint.FALSY)).isPresent()) {
            this.pushConditionSuccessor(block.falseSuccessor(), constrainedFalsePS.get(), conditionSymbolicValue, Constraint.FALSY, block.branchingTree());
            this.conditionResults.put((Object)lastElement, (Object)Constraint.FALSY);
        }
        if (!constrainedTruePS.isPresent() && !constrainedFalsePS.isPresent()) {
            throw new IllegalStateException("At least one branch of condition should be executed (condition on line " + lastElement.firstToken().line() + ").");
        }
    }

    private void pushConditionSuccessor(CfgBlock successor, ProgramState programState, SymbolicValue conditionSymbolicValue, Constraint constraint, Tree branchingTree) {
        ProgramState state = programState;
        if (!successor.elements().isEmpty() && successor.elements().get(0).is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            if (UnknownSymbolicValue.UNKNOWN.equals(conditionSymbolicValue)) {
                state = state.removeLastValue();
                state = state.pushToStack(new SymbolicValueWithConstraint(constraint));
            }
        } else {
            state = state.removeLastValue();
            if (branchingTree.is(Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT)) {
                state.assertEmptyStack(branchingTree);
            }
        }
        this.pushSuccessor(successor, state);
    }

    private ProgramState newSymbolicValue(ProgramState currentState, Tree left) {
        Symbol trackedVariable = this.trackedVariable(left);
        if (trackedVariable != null) {
            return currentState.newSymbolicValue(trackedVariable, null);
        }
        return currentState;
    }

    private ProgramState assignment(ProgramState currentState, Tree variable) {
        Symbol trackedVariable = this.trackedVariable(variable);
        if (trackedVariable != null) {
            return currentState.assignment(trackedVariable);
        }
        return currentState;
    }

    @CheckForNull
    public Symbol trackedVariable(Tree tree) {
        Symbol var = null;
        if (tree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            var = this.trackedVariable(((ParenthesisedExpressionTree)tree).expression());
        } else if (tree.is(Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.BINDING_IDENTIFIER)) {
            IdentifierTree identifier = (IdentifierTree)tree;
            Symbol symbol = identifier.symbol().orElse(null);
            var = this.trackedVariables.contains(symbol) ? symbol : null;
        } else if (tree.is(Tree.Kind.ASSIGNMENT_PATTERN_REST_ELEMENT)) {
            var = this.trackedVariable(((AssignmentPatternRestElementTree)tree).element());
        } else if (tree.is(Tree.Kind.INITIALIZED_ASSIGNMENT_PATTERN_ELEMENT)) {
            var = this.trackedVariable(((InitializedAssignmentPatternElementTree)tree).left());
        } else if (tree.is(Tree.Kind.OBJECT_ASSIGNMENT_PATTERN_PAIR_ELEMENT)) {
            var = this.trackedVariable(((ObjectAssignmentPatternPairElementTree)tree).element());
        } else if (tree.is(Tree.Kind.REST_ELEMENT)) {
            var = this.trackedVariable(((RestElementTree)tree).element());
        } else if (tree.is(Tree.Kind.BINDING_PROPERTY)) {
            var = this.trackedVariable(((BindingPropertyTree)tree).value());
        } else if (tree.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
            var = this.trackedVariable(((InitializedBindingElementTree)tree).left());
        }
        return var;
    }
}

