/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.limitations;

import java.util.HashSet;
import java.util.Set;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.LogicalNotSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class CrossProceduralLimitation {
    public ProgramState prepareForBranching(Tree condition, ProgramState currentState) {
        if (CrossProceduralLimitation.conditionIsAmbiguous(currentState)) {
            return CrossProceduralLimitation.dropConstraintsOnSymbols(currentState, FunctionArgumentsCollector.collect(condition));
        }
        return currentState;
    }

    private static ProgramState dropConstraintsOnSymbols(ProgramState incomingState, Set<Symbol> involvedSymbols) {
        ProgramState currentState = incomingState;
        for (Symbol symbol : involvedSymbols) {
            currentState = currentState.newSymbolicValue(symbol, Constraint.ANY_VALUE);
        }
        return currentState;
    }

    private static boolean conditionIsAmbiguous(ProgramState currentState) {
        SymbolicValue value = currentState.peekStack();
        if (value instanceof LogicalNotSymbolicValue) {
            return currentState.getConstraint(((LogicalNotSymbolicValue)value).negatedValue()).equals(Constraint.ANY_VALUE);
        }
        return currentState.getConstraint(value).equals(Constraint.ANY_VALUE);
    }

    static class FunctionArgumentsCollector
    extends DoubleDispatchVisitor {
        private Set<Symbol> symbols = new HashSet<Symbol>();

        FunctionArgumentsCollector() {
        }

        public static Set<Symbol> collect(Tree tree) {
            FunctionArgumentsCollector collector = new FunctionArgumentsCollector();
            tree.accept(collector);
            collector.symbols.remove(null);
            return collector.symbols;
        }

        @Override
        public void visitCallExpression(CallExpressionTree tree) {
            for (Tree tree2 : tree.argumentClause().arguments()) {
                if (!(tree2 instanceof IdentifierTree)) continue;
                ((IdentifierTree)tree2).symbol().ifPresent(this.symbols::add);
            }
            super.visitCallExpression(tree);
        }
    }
}

