/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.points;

import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ExpressionStack;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.SymbolicValue;

public abstract class BinaryProgramPoint
implements ProgramPoint {
    private Constraint firstOperandConstraint;
    private Constraint secondOperandConstraint;

    @Override
    public final Optional<ProgramState> execute(ProgramState state) {
        return Optional.of(this.transformState(state));
    }

    private ProgramState transformState(ProgramState state) {
        ExpressionStack stack = state.getStack();
        ExpressionStack stackAfterExecution = stack.apply(newStack -> {
            SymbolicValue secondOperandValue = (SymbolicValue)newStack.pop();
            this.secondOperandConstraint = state.getConstraint(secondOperandValue);
            SymbolicValue firstOperandValue = (SymbolicValue)newStack.pop();
            this.firstOperandConstraint = state.getConstraint(firstOperandValue);
            newStack.push(this.resolveValue(this.firstOperandConstraint, this.secondOperandConstraint, firstOperandValue, secondOperandValue));
        });
        return state.withStack(stackAfterExecution);
    }

    public Constraint resultingConstraint(ProgramState currentState) {
        ProgramState newPS = this.transformState(currentState);
        return newPS.getConstraint(newPS.peekStack());
    }

    protected abstract SymbolicValue resolveValue(Constraint var1, Constraint var2, @Deprecated SymbolicValue var3, @Deprecated SymbolicValue var4);

    public Constraint firstOperandConstraint() {
        return this.firstOperandConstraint;
    }

    public Constraint secondOperandConstraint() {
        return this.secondOperandConstraint;
    }
}

