/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.RelationalSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;

public class EqualitySymbolicValue
extends RelationalSymbolicValue {
    protected static final Set<Tree.Kind> EQUALITY_NEGATION_KINDS = EnumSet.of(Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO);
    protected static final Set<Tree.Kind> EQUALITY_KINDS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO);
    private final Tree.Kind kind;
    private final SymbolicValue leftOperand;
    private final SymbolicValue rightOperand;

    EqualitySymbolicValue(Tree.Kind kind, SymbolicValue leftOperand, SymbolicValue rightOperand) {
        super(kind, leftOperand, rightOperand);
        this.kind = kind;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState incomingState, Constraint constraint) {
        Optional<ProgramState> constrainedState = super.constrainDependencies(incomingState, constraint);
        constrainedState = this.constrainOperand(this.leftOperand, this.rightOperand, constraint, constrainedState.orElse(null));
        constrainedState = this.constrainOperand(this.rightOperand, this.leftOperand, constraint, constrainedState.orElse(null));
        return constrainedState;
    }

    private Optional<ProgramState> constrainOperand(SymbolicValue sending, SymbolicValue receiving, Constraint constraint, @Nullable ProgramState incomingState) {
        if (incomingState != null) {
            return this.constrainOperand(sending, receiving, incomingState, constraint);
        }
        return Optional.empty();
    }

    private Optional<ProgramState> constrainOperand(SymbolicValue sending, SymbolicValue receiving, ProgramState state, Constraint constraint) {
        Constraint constraintOnSending = state.getConstraint(sending);
        if (constraintOnSending.isStricterOrEqualTo(Constraint.NULL_OR_UNDEFINED)) {
            if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
                return state.constrain(receiving, this.constraintOnNullOrUndefined(constraintOnSending, false));
            }
            if (constraint.isStricterOrEqualTo(Constraint.FALSY)) {
                return state.constrain(receiving, this.constraintOnNullOrUndefined(constraintOnSending, true));
            }
        }
        if (Tree.Kind.STRICT_EQUAL_TO.equals(this.kind)) {
            if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
                return state.constrain(receiving, constraintOnSending);
            }
            if (constraint.isStricterOrEqualTo(Constraint.FALSY) && constraintOnSending.isSingleValue()) {
                return state.constrain(receiving, constraintOnSending.not());
            }
        }
        if (Tree.Kind.STRICT_NOT_EQUAL_TO.equals(this.kind)) {
            if (constraint.isStricterOrEqualTo(Constraint.FALSY)) {
                return state.constrain(receiving, constraintOnSending);
            }
            if (constraint.isStricterOrEqualTo(Constraint.TRUTHY) && constraintOnSending.isSingleValue()) {
                return state.constrain(receiving, constraintOnSending.not());
            }
        }
        return Optional.of(state);
    }

    private Constraint constraintOnNullOrUndefined(Constraint constraintOnSending, boolean negate) {
        Constraint constraint;
        if (Tree.Kind.STRICT_EQUAL_TO.equals(this.kind)) {
            constraint = constraintOnSending;
        } else if (Tree.Kind.STRICT_NOT_EQUAL_TO.equals(this.kind)) {
            if (Constraint.NULL_OR_UNDEFINED.equals(constraintOnSending)) {
                return Constraint.ANY_VALUE;
            }
            constraint = constraintOnSending.not();
        } else {
            constraint = Tree.Kind.EQUAL_TO.equals(this.kind) ? Constraint.NULL_OR_UNDEFINED : Constraint.NULL_OR_UNDEFINED.not();
        }
        return negate ? constraint.not() : constraint;
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        Constraint singleValueEqualityConstraint;
        Constraint rightConstraint;
        Constraint leftConstraint = state.getConstraint(this.leftOperand);
        if (leftConstraint.isIncompatibleWith(rightConstraint = state.getConstraint(this.rightOperand))) {
            if (this.kind == Tree.Kind.STRICT_EQUAL_TO) {
                return Constraint.FALSE;
            }
            if (this.kind == Tree.Kind.STRICT_NOT_EQUAL_TO) {
                return Constraint.TRUE;
            }
        }
        if ((singleValueEqualityConstraint = this.resolveSingleValueEqualityConstraint(leftConstraint, rightConstraint)) != null) {
            return singleValueEqualityConstraint;
        }
        return super.baseConstraint(state);
    }

    private Constraint resolveSingleValueEqualityConstraint(Constraint leftConstraint, Constraint rightConstraint) {
        if (this.sameSingleValues(leftConstraint, rightConstraint)) {
            if (EQUALITY_KINDS.contains(this.kind)) {
                return Constraint.TRUE;
            }
            if (EQUALITY_NEGATION_KINDS.contains(this.kind)) {
                return Constraint.FALSE;
            }
        }
        if (this.differentSingleValues(leftConstraint, rightConstraint)) {
            if (this.kind == Tree.Kind.STRICT_EQUAL_TO) {
                return Constraint.FALSE;
            }
            if (this.kind == Tree.Kind.STRICT_NOT_EQUAL_TO) {
                return Constraint.TRUE;
            }
        }
        return null;
    }

    private boolean sameSingleValues(Constraint leftConstraint, Constraint rightConstraint) {
        return this.bothSingleValueConstraints(leftConstraint, rightConstraint) && leftConstraint.equals(rightConstraint);
    }

    private boolean differentSingleValues(Constraint leftConstraint, Constraint rightConstraint) {
        return this.bothSingleValueConstraints(leftConstraint, rightConstraint) && !leftConstraint.equals(rightConstraint);
    }

    private boolean bothSingleValueConstraints(Constraint leftConstraint, Constraint rightConstraint) {
        return leftConstraint.isSingleValue() && rightConstraint.isSingleValue();
    }
}

