/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.builtins.BuiltInProperty;

public class ArrayBuiltInProperties {
    private static final List<Constraint> functionAndObject = ImmutableList.of((Object)Constraint.FUNCTION, (Object)Constraint.OBJECT);
    private static final List<Constraint> anyValueAndNumber = ImmutableList.of((Object)Constraint.ANY_VALUE, (Object)Constraint.ANY_NUMBER);
    private static final IntFunction<Constraint> anyValues = index -> Constraint.ANY_VALUE;
    public static final Map<String, BuiltInProperty> PROTOTYPE_PROPERTIES = ImmutableMap.builder().put((Object)"copyWithin", (Object)BuiltInProperty.method(Constraint.ARRAY, (List<Constraint>)ImmutableList.of((Object)Constraint.ANY_NUMBER, (Object)Constraint.ANY_NUMBER, (Object)Constraint.ANY_NUMBER), true)).put((Object)"fill", (Object)BuiltInProperty.method(Constraint.ARRAY, (List<Constraint>)ImmutableList.of((Object)Constraint.ANY_VALUE, (Object)Constraint.ANY_NUMBER, (Object)Constraint.ANY_NUMBER), true)).put((Object)"push", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, anyValues, true)).put((Object)"reverse", (Object)BuiltInProperty.method(Constraint.ARRAY, BuiltInProperty.EMPTY, true)).put((Object)"sort", (Object)BuiltInProperty.method(Constraint.ARRAY, (List<Constraint>)ImmutableList.of((Object)Constraint.FUNCTION), true)).put((Object)"splice", (Object)BuiltInProperty.method(Constraint.ARRAY, index -> {
        if (index == 0 || index == 1) {
            return Constraint.ANY_NUMBER;
        }
        return Constraint.ANY_VALUE;
    }, true)).put((Object)"unshift", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, anyValues, true)).put((Object)"concat", (Object)BuiltInProperty.method(Constraint.ARRAY, anyValues)).put((Object)"includes", (Object)BuiltInProperty.method(Constraint.BOOLEAN_PRIMITIVE, anyValueAndNumber)).put((Object)"join", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.ONE_STRING)).put((Object)"slice", (Object)BuiltInProperty.method(Constraint.ARRAY, BuiltInProperty.NUMBER_NUMBER)).put((Object)"indexOf", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, anyValueAndNumber)).put((Object)"lastIndexOf", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, anyValueAndNumber)).put((Object)"forEach", (Object)BuiltInProperty.method(Constraint.UNDEFINED, functionAndObject, true)).put((Object)"entries", (Object)BuiltInProperty.method(Constraint.OTHER_OBJECT, BuiltInProperty.EMPTY)).put((Object)"every", (Object)BuiltInProperty.method(Constraint.BOOLEAN_PRIMITIVE, functionAndObject)).put((Object)"some", (Object)BuiltInProperty.method(Constraint.BOOLEAN_PRIMITIVE, functionAndObject)).put((Object)"filter", (Object)BuiltInProperty.method(Constraint.ARRAY, functionAndObject)).put((Object)"findIndex", (Object)BuiltInProperty.method(Constraint.NUMBER_PRIMITIVE, functionAndObject)).put((Object)"keys", (Object)BuiltInProperty.method(Constraint.OTHER_OBJECT, BuiltInProperty.EMPTY)).put((Object)"map", (Object)BuiltInProperty.method(Constraint.ARRAY, functionAndObject)).put((Object)"values", (Object)BuiltInProperty.method(Constraint.OTHER_OBJECT, BuiltInProperty.EMPTY)).put((Object)"pop", (Object)BuiltInProperty.method(Constraint.ANY_VALUE, BuiltInProperty.EMPTY, true)).put((Object)"shift", (Object)BuiltInProperty.method(Constraint.ANY_VALUE, BuiltInProperty.EMPTY, true)).put((Object)"find", (Object)BuiltInProperty.method(Constraint.ANY_VALUE, functionAndObject)).put((Object)"reduce", (Object)BuiltInProperty.method(Constraint.ANY_VALUE, (List<Constraint>)ImmutableList.of((Object)Constraint.FUNCTION, (Object)Constraint.ANY_VALUE))).put((Object)"reduceRight", (Object)BuiltInProperty.method(Constraint.ANY_VALUE, (List<Constraint>)ImmutableList.of((Object)Constraint.FUNCTION, (Object)Constraint.ANY_VALUE))).put((Object)"toString", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"toLocaleString", (Object)BuiltInProperty.method(Constraint.STRING_PRIMITIVE, BuiltInProperty.EMPTY)).put((Object)"length", (Object)BuiltInProperty.property(Constraint.POSITIVE_NUMBER_PRIMITIVE.or(Constraint.ZERO))).build();
    public static final Map<String, BuiltInProperty> PROPERTIES = ImmutableMap.builder().put((Object)"from", (Object)BuiltInProperty.method(Constraint.ARRAY, (List<Constraint>)ImmutableList.of((Object)Constraint.ANY_VALUE, (Object)Constraint.FUNCTION, (Object)Constraint.ANY_VALUE))).put((Object)"isArray", (Object)BuiltInProperty.method(Constraint.BOOLEAN_PRIMITIVE, BuiltInProperty.getIsSomethingArgumentsConstrainer(Constraint.ARRAY), (List<Constraint>)ImmutableList.of((Object)Constraint.ANY_VALUE))).put((Object)"of", (Object)BuiltInProperty.method(Constraint.ARRAY, index -> Constraint.ANY_VALUE)).build();

    private ArrayBuiltInProperties() {
    }
}

