/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.points;

import java.util.Optional;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SymbolicExecution;
import org.sonar.javascript.se.points.BitwiseBinaryProgramPoint;
import org.sonar.javascript.se.points.IdentifierProgramPoint;
import org.sonar.javascript.se.points.LiteralProgramPoint;
import org.sonar.javascript.se.points.MemberProgramPoint;
import org.sonar.javascript.se.points.NoActionProgramPoint;
import org.sonar.javascript.se.points.PlusProgramPoint;
import org.sonar.javascript.se.points.StrictlyArithmeticBinaryProgramPoint;
import org.sonar.javascript.se.points.UnaryNumericProgramPoint;
import org.sonar.plugins.javascript.api.tree.Tree;

public interface ProgramPoint {
    public Optional<ProgramState> execute(ProgramState var1);

    public static ProgramPoint create(Tree element, SymbolicExecution execution) {
        if (MemberProgramPoint.originatesFrom(element)) {
            return new MemberProgramPoint(element);
        }
        if (PlusProgramPoint.originatesFrom(element)) {
            return new PlusProgramPoint();
        }
        if (StrictlyArithmeticBinaryProgramPoint.originatesFrom(element)) {
            return new StrictlyArithmeticBinaryProgramPoint();
        }
        if (BitwiseBinaryProgramPoint.originatesFrom(element)) {
            return new BitwiseBinaryProgramPoint();
        }
        if (UnaryNumericProgramPoint.originatesFrom(element)) {
            return new UnaryNumericProgramPoint(element, execution);
        }
        if (IdentifierProgramPoint.originatesFrom(element)) {
            return new IdentifierProgramPoint(element, execution);
        }
        if (LiteralProgramPoint.originatesFrom(element)) {
            return new LiteralProgramPoint(element);
        }
        return new NoActionProgramPoint();
    }
}

