/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.points;

import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ExpressionStack;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SymbolicExecution;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.IncDecSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;
import org.sonar.javascript.se.sv.UnaryMinusSymbolicValue;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;

public class UnaryNumericProgramPoint
implements ProgramPoint {
    private UnaryExpressionTree element;
    private SymbolicExecution execution;
    private SymbolicValue expressionValue;
    private SymbolicValue assignedValue = null;

    public UnaryNumericProgramPoint(Tree element, SymbolicExecution execution) {
        this.element = (UnaryExpressionTree)element;
        this.execution = execution;
    }

    @Override
    public Optional<ProgramState> execute(ProgramState state) {
        ExpressionStack stack = state.getStack();
        ExpressionStack stackAfterExecution = stack.apply(newStack -> {
            SymbolicValue operandValue = (SymbolicValue)newStack.pop();
            Constraint operandConstraint = state.getConstraint(operandValue);
            this.execute(operandValue, operandConstraint);
            newStack.push(this.expressionValue);
        });
        ProgramState newPS = state.withStack(stackAfterExecution);
        newPS = this.executeAssignment(newPS);
        return Optional.of(newPS);
    }

    private void execute(SymbolicValue operandValue, Constraint operandConstraint) {
        IncDecSymbolicValue.Sign sign;
        if (this.element.is(Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT)) {
            sign = this.element.is(Tree.Kind.PREFIX_INCREMENT) ? IncDecSymbolicValue.Sign.PLUS : IncDecSymbolicValue.Sign.MINUS;
            this.assignedValue = this.expressionValue = new IncDecSymbolicValue(sign, operandValue);
        }
        if (this.element.is(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT)) {
            sign = this.element.is(Tree.Kind.POSTFIX_INCREMENT) ? IncDecSymbolicValue.Sign.PLUS : IncDecSymbolicValue.Sign.MINUS;
            this.expressionValue = this.convertToNumber(operandValue, operandConstraint);
            this.assignedValue = new IncDecSymbolicValue(sign, operandValue);
        }
        if (this.element.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
            this.assignedValue = null;
            this.expressionValue = this.element.is(Tree.Kind.UNARY_PLUS) ? this.convertToNumber(operandValue, operandConstraint) : new UnaryMinusSymbolicValue(operandValue);
        }
    }

    private SymbolicValue convertToNumber(SymbolicValue operandValue, Constraint operandConstraint) {
        boolean requiresConversionToNumber = !operandConstraint.isStricterOrEqualTo(Constraint.NUMBER_PRIMITIVE);
        return requiresConversionToNumber ? new SymbolicValueWithConstraint(Constraint.NUMBER_PRIMITIVE) : operandValue;
    }

    private ProgramState executeAssignment(ProgramState state) {
        Symbol symbol;
        ProgramState newPS = state;
        if (this.assignedValue != null && (symbol = this.execution.trackedVariable(this.element.expression())) != null) {
            newPS = newPS.assignment(symbol, this.assignedValue);
        }
        return newPS;
    }

    public static boolean originatesFrom(Tree element) {
        return element.is(Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, KindSet.INC_DEC_KINDS);
    }
}

