/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class PlusSymbolicValue
implements SymbolicValue {
    private static final Constraint NUMBER_OR_BOOLEAN = Constraint.ANY_NUMBER.or(Constraint.ANY_BOOLEAN);
    private final SymbolicValue firstOperandValue;
    private final SymbolicValue secondOperandValue;

    public PlusSymbolicValue(SymbolicValue firstOperandValue, SymbolicValue secondOperandValue) {
        this.firstOperandValue = firstOperandValue;
        this.secondOperandValue = secondOperandValue;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        Constraint secondConstraint;
        Constraint firstConstraint = state.getConstraint(this.firstOperandValue);
        if (PlusSymbolicValue.atLeastOneUndefined(firstConstraint, secondConstraint = state.getConstraint(this.secondOperandValue)) && (PlusSymbolicValue.atLeastOneNumberOrBoolean(firstConstraint, secondConstraint) || PlusSymbolicValue.bothUndefined(firstConstraint, secondConstraint))) {
            return Constraint.NAN;
        }
        if (PlusSymbolicValue.atLeastOneString(firstConstraint, secondConstraint)) {
            return Constraint.STRING_PRIMITIVE;
        }
        if (PlusSymbolicValue.bothNumberOrBoolean(firstConstraint, secondConstraint)) {
            return Constraint.NUMBER_PRIMITIVE;
        }
        return Constraint.NUMBER_PRIMITIVE.or(Constraint.STRING_PRIMITIVE);
    }

    private static boolean bothUndefined(Constraint firstConstraint, Constraint secondConstraint) {
        return firstConstraint.isStricterOrEqualTo(Constraint.UNDEFINED) && secondConstraint.isStricterOrEqualTo(Constraint.UNDEFINED);
    }

    private static boolean atLeastOneString(Constraint firstConstraint, Constraint secondConstraint) {
        return firstConstraint.isStricterOrEqualTo(Constraint.ANY_STRING) || secondConstraint.isStricterOrEqualTo(Constraint.ANY_STRING);
    }

    private static boolean atLeastOneUndefined(Constraint firstConstraint, Constraint secondConstraint) {
        return firstConstraint.isStricterOrEqualTo(Constraint.UNDEFINED) || secondConstraint.isStricterOrEqualTo(Constraint.UNDEFINED);
    }

    private static boolean atLeastOneNumberOrBoolean(Constraint firstConstraint, Constraint secondConstraint) {
        return firstConstraint.isStricterOrEqualTo(NUMBER_OR_BOOLEAN) || secondConstraint.isStricterOrEqualTo(NUMBER_OR_BOOLEAN);
    }

    private static boolean bothNumberOrBoolean(Constraint firstConstraint, Constraint secondConstraint) {
        return firstConstraint.isStricterOrEqualTo(NUMBER_OR_BOOLEAN) && secondConstraint.isStricterOrEqualTo(NUMBER_OR_BOOLEAN);
    }

    public String toString() {
        return this.firstOperandValue + " + " + this.secondOperandValue;
    }
}

