/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;

public class SeparatedListImpl<T>
implements SeparatedList<T> {
    private final List<T> list;
    private final List<InternalSyntaxToken> separators;

    public SeparatedListImpl(List<T> list, List<InternalSyntaxToken> separators) {
        Preconditions.checkArgument((list.size() == separators.size() + 1 || list.size() == separators.size() ? 1 : 0) != 0, (String)"Instanciating a SeparatedList with inconsistent number of elements (%s) and separators (%s)", (int)list.size(), (int)separators.size());
        this.list = list;
        this.separators = separators;
    }

    public static SeparatedListImpl emptyImmutableList() {
        return new SeparatedListImpl(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public InternalSyntaxToken getSeparator(int i) {
        return this.separators.get(i);
    }

    @Override
    public List<InternalSyntaxToken> getSeparators() {
        return this.separators;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Iterator<Tree> elementsAndSeparators(Function<T, ? extends Tree> elementTransformer) {
        return new ElementAndSeparatorIterator(elementTransformer);
    }

    private final class ElementAndSeparatorIterator
    extends UnmodifiableIterator<Tree> {
        private final Function<T, ? extends Tree> elementTransformer;
        private final Iterator<T> elementIterator;
        private final Iterator<InternalSyntaxToken> separatorIterator;
        private boolean nextIsElement;

        private ElementAndSeparatorIterator(Function<T, ? extends Tree> elementTransformer) {
            this.elementIterator = SeparatedListImpl.this.list.iterator();
            this.separatorIterator = SeparatedListImpl.this.separators.iterator();
            this.nextIsElement = true;
            this.elementTransformer = elementTransformer;
        }

        public boolean hasNext() {
            return this.elementIterator.hasNext() || this.separatorIterator.hasNext();
        }

        public Tree next() {
            Tree next = this.nextIsElement ? (Tree)this.elementTransformer.apply(this.elementIterator.next()) : (Tree)this.separatorIterator.next();
            this.nextIsElement = !this.nextIsElement;
            return next;
        }
    }
}

