/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class JQuery {
    public static final String JQUERY_OBJECT_ALIASES = "sonar.javascript.jQueryObjectAliases";
    public static final String JQUERY_OBJECT_ALIASES_DEFAULT_VALUE = "$, jQuery";
    private static final List<String> SELECTOR_METHODS = ImmutableList.of();
    private List<String> jQueryAliases = null;

    public JQuery(String[] jQueryAliases) {
        this.jQueryAliases = Arrays.asList(jQueryAliases);
    }

    public boolean isJQueryObject(IdentifierTree identifierTree) {
        return this.jQueryAliases.contains(identifierTree.name());
    }

    private boolean isDirectJQuerySelectorObject(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.CALL_EXPRESSION)) {
            ExpressionTree callee = ((CallExpressionTree)expressionTree).callee();
            return callee.is(Tree.Kind.IDENTIFIER_REFERENCE) && this.isJQueryObject((IdentifierTree)callee);
        }
        return false;
    }

    protected boolean isSelectorObject(ExpressionTree expressionTree) {
        if (this.isDirectJQuerySelectorObject(expressionTree)) {
            return true;
        }
        if (expressionTree.is(Tree.Kind.CALL_EXPRESSION) && ((CallExpressionTree)expressionTree).callee().is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
            DotMemberExpressionTree callee = (DotMemberExpressionTree)((CallExpressionTree)expressionTree).callee();
            return this.isSelectorObject(callee.object()) && JQuery.isJQuerySelectorMethod(callee.property());
        }
        return false;
    }

    private static boolean isJQuerySelectorMethod(IdentifierTree property) {
        return SELECTOR_METHODS.contains(property.name());
    }
}

