/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class BundleUtils {
    private BundleUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractFromClasspath(InputStream resource, Path targetPath) throws IOException {
        Objects.requireNonNull(resource);
        try (XZCompressorInputStream xzi = new XZCompressorInputStream((InputStream)new BufferedInputStream(resource));
             TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)xzi);){
            ArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (!archive.canReadEntryData(entry)) {
                    throw new IllegalStateException("Failed to extract bundle");
                }
                File entryFile = BundleUtils.entryPath(targetPath, entry).toFile();
                if (entry.isDirectory()) {
                    if (entryFile.isDirectory() || entryFile.mkdirs()) continue;
                    throw new IOException("failed to create directory " + entryFile);
                }
                File parent = entryFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("failed to create directory " + parent);
                }
                OutputStream os = Files.newOutputStream(entryFile.toPath(), new OpenOption[0]);
                try {
                    IOUtils.copy((InputStream)archive, (OutputStream)os);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            return;
        }
    }

    private static Path entryPath(Path targetPath, ArchiveEntry entry) {
        Path entryPath = targetPath.resolve(entry.getName());
        if (!entryPath.startsWith(targetPath)) {
            throw new IllegalStateException("Archive entry " + entry.getName() + " is not within " + targetPath);
        }
        return entryPath;
    }
}

